/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators.AbstractGrowthAccelerator;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public class WaterSprinkler
extends AbstractGrowthAccelerator {
    public final ItemSetting<Double> successChance = new ItemSetting((SlimefunItem)this, "success-chance", (Object)0.5);
    public static final int ENERGY_CONSUMPTION = 16;
    public static final int CAPACITY = 128;
    private static final int RADIUS = 2;
    private static final int PROGRESS_SLOT = 4;
    private static final CustomItemStack noWaterItem = new CustomItemStack(Material.BUCKET, "&cNo water found", new String[]{"", "&cPlease place water under the sprinkler!"});
    private static final CustomItemStack waterFoundItem = new CustomItemStack(Material.WATER_BUCKET, "&bWater detected", new String[0]);
    private final ItemSetting<Boolean> particles = new ItemSetting((SlimefunItem)this, "particles", (Object)true);

    public WaterSprinkler(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.createPreset((SlimefunItem)this, "&bWater Sprinkler", blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)noWaterItem);
        });
        this.addItemSetting(new ItemSetting[]{this.successChance, this.particles});
    }

    public int getEnergyConsumption() {
        return 16;
    }

    public int getCapacity() {
        return 128;
    }

    public int getRadius() {
        return 2;
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    protected void tick(@Nonnull Block b) {
        if (this.isDisabled()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        boolean open = inv.hasViewer();
        if (b.getRelative(BlockFace.DOWN).getType() == Material.WATER) {
            if (open) {
                inv.replaceExistingItem(4, (ItemStack)waterFoundItem);
            }
        } else {
            if (open) {
                inv.replaceExistingItem(4, (ItemStack)noWaterItem);
            }
            return;
        }
        if (this.getCharge(b.getLocation()) >= this.getEnergyConsumption()) {
            for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
                for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                    BlockData blockData;
                    Block block = b.getRelative(x, 0, z);
                    if (((Boolean)this.particles.getValue()).booleanValue()) {
                        block.getWorld().spawnParticle(Particle.WATER_SPLASH, block.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                    }
                    if (!((blockData = block.getBlockData()) instanceof Ageable)) continue;
                    this.grow(block);
                    this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                }
            }
        }
    }

    private void grow(@Nonnull Block crop) {
        double random = ThreadLocalRandom.current().nextDouble();
        if ((Double)this.successChance.getValue() >= random) {
            if (crop.getType() == Material.SUGAR_CANE) {
                for (int i = 1; i < 3; ++i) {
                    Block above = crop.getRelative(BlockFace.UP, i);
                    if (above.getType().isAir()) {
                        above.setType(Material.SUGAR_CANE);
                        break;
                    }
                    if (above.getType() == Material.SUGAR_CANE) continue;
                    return;
                }
            } else {
                Ageable ageable = (Ageable)crop.getBlockData();
                if (ageable.getAge() < ageable.getMaximumAge()) {
                    ageable.setAge(ageable.getAge() + 1);
                    crop.setBlockData((BlockData)ageable);
                    crop.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, crop.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                }
            }
        }
    }
}

