/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.fluffymachines.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import io.ncbpfluffybear.fluffymachines.objects.DoubleHologramOwner;
import io.ncbpfluffybear.fluffymachines.objects.NonHopperableBlock;
import io.ncbpfluffybear.fluffymachines.utils.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class Barrel
extends NonHopperableBlock
implements DoubleHologramOwner {
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private final int[] outputBorder = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private final int[] plainBorder = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    protected final int[] INPUT_SLOTS = new int[]{19, 20};
    protected final int[] OUTPUT_SLOTS = new int[]{24, 25};
    private final int STATUS_SLOT = 22;
    private final int DISPLAY_SLOT = 31;
    private final int HOLOGRAM_TOGGLE_SLOT = 36;
    private final int TRASH_TOGGLE_SLOT = 37;
    private final int OVERFLOW_AMOUNT = 3240;
    public static final DecimalFormat STORAGE_INDICATOR_FORMAT = new DecimalFormat("###,###.####", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private final ItemStack HOLOGRAM_OFF_ITEM = new CustomItemStack(Material.QUARTZ_SLAB, "&3Toggle Hologram &c(Off)", new String[0]);
    private final ItemStack HOLOGRAM_ON_ITEM = new CustomItemStack(Material.QUARTZ_SLAB, "&3Toggle Hologram &a(On)", new String[0]);
    private final ItemStack TRASH_ON_ITEM = new CustomItemStack((ItemStack)SlimefunItems.TRASH_CAN, "&3Toggle Overfill Trash &a(On)", new String[]{"&7Turn on to delete unstorable items"});
    private final ItemStack TRASH_OFF_ITEM = new CustomItemStack((ItemStack)SlimefunItems.TRASH_CAN, "&3Toggle Overfill Trash &c(Off)", new String[]{"&7Turn on to delete unstorable items"});
    private final ItemSetting<Boolean> showHologram = new ItemSetting((SlimefunItem)this, "show-hologram", (Object)true);
    private final ItemSetting<Boolean> breakOnlyWhenEmpty = new ItemSetting((SlimefunItem)this, "break-only-when-empty", (Object)false);
    protected final ItemSetting<Integer> barrelCapacity;

    public Barrel(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int MAX_STORAGE) {
        super(category, item, recipeType, recipe);
        this.barrelCapacity = new IntRangeSetting((SlimefunItem)this, "capacity", 0, MAX_STORAGE, Integer.MAX_VALUE);
        this.addItemSetting(new ItemSetting[]{this.barrelCapacity});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                Barrel.this.constructMenu(this);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                Barrel.this.buildMenu(menu, b);
            }

            public boolean canOpen(@Nonnull Block b, @Nonnull Player p) {
                if (Utils.canOpen(b, p)) {
                    Barrel.this.updateMenu(b, BlockStorage.getInventory((Block)b), true, Barrel.this.getCapacity(b));
                    return true;
                }
                return false;
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT) {
                    return Barrel.this.INPUT_SLOTS;
                }
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return Barrel.this.OUTPUT_SLOTS;
                }
                return new int[0];
            }
        };
        this.addItemHandler(new ItemHandler[]{this.onBreak()});
        this.addItemSetting(new ItemSetting[]{this.showHologram, this.breakOnlyWhenEmpty});
    }

    private ItemHandler onBreak() {
        return new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                Block b = e.getBlock();
                Player p = e.getPlayer();
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                int capacity = Barrel.this.getCapacity(b);
                int stored = Barrel.this.getStored(b);
                if (inv != null) {
                    int itemCount = 0;
                    if (((Boolean)Barrel.this.breakOnlyWhenEmpty.getValue()).booleanValue() && stored != 0) {
                        Utils.send((CommandSender)p, "&cThis barrel can't be broken since it has items inside it!");
                        e.setCancelled(true);
                        return;
                    }
                    for (Entity en : p.getNearbyEntities(5.0, 5.0, 5.0)) {
                        if (!(en instanceof Item)) continue;
                        ++itemCount;
                    }
                    if (itemCount > 5) {
                        Utils.send((CommandSender)p, "&cPlease remove nearby items before breaking this barrel!");
                        e.setCancelled(true);
                        return;
                    }
                    inv.dropItems(b.getLocation(), Barrel.this.INPUT_SLOTS);
                    inv.dropItems(b.getLocation(), Barrel.this.OUTPUT_SLOTS);
                    if (stored > 0) {
                        int stackSize = inv.getItemInSlot(31).getMaxStackSize();
                        ItemStack unKeyed = Barrel.this.getStoredItem(b);
                        if (unKeyed.getType() == Material.BARRIER) {
                            Barrel.this.setStored(b, 0);
                            Barrel.this.updateMenu(b, inv, true, capacity);
                            return;
                        }
                        if (stored > 3240) {
                            int toRemove;
                            Utils.send((CommandSender)p, "&eThere are more than 3240 items in this barrel! Dropping 3240 items instead!");
                            for (toRemove = 3240; toRemove >= stackSize; toRemove -= stackSize) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(unKeyed, stackSize));
                            }
                            if (toRemove > 0) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(unKeyed, toRemove));
                            }
                            Barrel.this.setStored(b, stored - 3240);
                            Barrel.this.updateMenu(b, inv, true, capacity);
                            e.setCancelled(true);
                        } else {
                            while (stored >= stackSize) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(unKeyed, stackSize));
                                stored -= stackSize;
                            }
                            if (stored > 0) {
                                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)new CustomItemStack(unKeyed, stored));
                            }
                            Barrel.this.setStored(b, 0);
                            Barrel.this.updateMenu(b, inv, true, capacity);
                            Barrel.this.removeHologram(b);
                        }
                    } else {
                        Barrel.this.removeHologram(b);
                    }
                }
            }
        };
    }

    private void constructMenu(BlockMenuPreset preset) {
        Utils.createBorder((ChestMenu)preset, ChestMenuUtils.getOutputSlotTexture(), this.outputBorder);
        Utils.createBorder((ChestMenu)preset, ChestMenuUtils.getInputSlotTexture(), this.inputBorder);
        ChestMenuUtils.drawBackground((ChestMenu)preset, (int[])this.plainBorder);
    }

    protected void buildMenu(BlockMenu menu, Block b) {
        int capacity = this.getCapacity(b);
        if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stored") == null) {
            menu.replaceExistingItem(22, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&6Items Stored: &e0 / " + capacity, new String[]{"&70%"}));
            menu.replaceExistingItem(31, (ItemStack)new CustomItemStack(Material.BARRIER, "&cEmpty", new String[0]));
            this.setStored(b, 0);
            if (((Boolean)this.showHologram.getValue()).booleanValue()) {
                this.updateHologram(b, null, "&cEmpty");
            }
        } else if (!((Boolean)this.showHologram.getValue()).booleanValue()) {
            this.removeHologram(b);
        }
        menu.addMenuClickHandler(22, ChestMenuUtils.getEmptyClickHandler());
        menu.addMenuClickHandler(31, ChestMenuUtils.getEmptyClickHandler());
        String holo = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"holo");
        if (holo == null || holo.equals("true")) {
            menu.replaceExistingItem(36, this.HOLOGRAM_ON_ITEM);
        } else {
            menu.replaceExistingItem(36, this.HOLOGRAM_OFF_ITEM);
        }
        menu.addMenuClickHandler(36, (pl, slot, item, action) -> {
            this.toggleHolo(b, capacity);
            return false;
        });
        String trash = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"trash");
        if (trash == null || trash.equals("false")) {
            menu.replaceExistingItem(37, this.TRASH_OFF_ITEM);
        } else {
            menu.replaceExistingItem(37, this.TRASH_ON_ITEM);
        }
        menu.addMenuClickHandler(37, (pl, slot, item, action) -> {
            this.toggleTrash(b);
            return false;
        });
        int INSERT_ALL_SLOT = 43;
        menu.replaceExistingItem(INSERT_ALL_SLOT, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&bInsert All", new String[]{"&7> Click here to insert all", "&7compatible items into the barrel"}));
        menu.addMenuClickHandler(INSERT_ALL_SLOT, (pl, slot, item, action) -> {
            this.insertAll(pl, menu, b);
            return false;
        });
        int EXTRACT_SLOT = 44;
        menu.replaceExistingItem(EXTRACT_SLOT, (ItemStack)new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&6Extract All", new String[]{"&7> Left click to extract", "&7all items to your inventory", "&7> Right click to extract 1 item"}));
        menu.addMenuClickHandler(EXTRACT_SLOT, (pl, slot, item, action) -> {
            this.extract(pl, menu, b, action);
            return false;
        });
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                Barrel.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        int capacity = this.getCapacity(b);
        for (int slot : this.INPUT_SLOTS) {
            this.acceptInput(inv, b, slot, capacity);
        }
        for (int ignored : this.OUTPUT_SLOTS) {
            this.pushOutput(inv, b, capacity);
        }
    }

    void acceptInput(BlockMenu inv, Block b, int slot, int capacity) {
        if (inv.getItemInSlot(slot) == null) {
            return;
        }
        int stored = this.getStored(b);
        ItemStack item = inv.getItemInSlot(slot);
        if (stored == 0) {
            this.registerItem(b, inv, slot, item, capacity, stored);
        } else if (stored > 0 && inv.getItemInSlot(31) != null && this.matchMeta(Utils.unKeyItem(inv.getItemInSlot(31)), item)) {
            if (stored < capacity) {
                if (stored + item.getAmount() <= capacity) {
                    this.storeItem(b, inv, slot, item, capacity, stored);
                } else {
                    int amount = capacity - stored;
                    inv.consumeItem(slot, amount);
                    this.setStored(b, stored + amount);
                    this.updateMenu(b, inv, false, capacity);
                }
            } else {
                String useTrash = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"trash");
                if (useTrash != null && useTrash.equals("true")) {
                    inv.replaceExistingItem(slot, null);
                }
            }
        }
    }

    public boolean fits(DirtyChestMenu inv, @Nonnull ItemStack item, int ... slots) {
        int metaMismatches = 0;
        for (int slot : slots) {
            ItemStack slotItem = inv.getItemInSlot(slot);
            if (inv.getItemInSlot(slot) == null) {
                return true;
            }
            if (this.matchMeta(item, slotItem)) continue;
            ++metaMismatches;
        }
        if (metaMismatches == slots.length) {
            return false;
        }
        return InvUtils.fits((Inventory)inv.toInventory(), (ItemStack)ItemStackWrapper.wrap((ItemStack)item), (int[])slots);
    }

    @Nullable
    public ItemStack pushItem(DirtyChestMenu inv, ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot push null or AIR");
        }
        ItemStackWrapper wrapper = null;
        int amount = item.getAmount();
        for (int slot : slots) {
            if (amount <= 0) break;
            ItemStack stack = inv.getItemInSlot(slot);
            if (stack == null) {
                inv.replaceExistingItem(slot, item);
                return null;
            }
            int maxStackSize = Math.min(stack.getMaxStackSize(), inv.toInventory().getMaxStackSize());
            if (stack.getAmount() >= maxStackSize) continue;
            if (wrapper == null) {
                wrapper = ItemStackWrapper.wrap((ItemStack)item);
            }
            if (!ItemUtils.canStack((ItemStack)wrapper, (ItemStack)stack) || !this.matchMeta((ItemStack)wrapper, stack)) continue;
            stack.setAmount(Math.min(stack.getAmount() + item.getAmount(), maxStackSize));
            item.setAmount(amount -= maxStackSize - stack.getAmount());
        }
        if (amount > 0) {
            return new CustomItemStack(item, amount);
        }
        return null;
    }

    void pushOutput(BlockMenu inv, Block b, int capacity) {
        ItemStack displayItem = inv.getItemInSlot(31);
        if (displayItem != null && displayItem.getType() != Material.BARRIER) {
            CustomItemStack clone;
            int stored = this.getStored(b);
            if (stored > displayItem.getMaxStackSize()) {
                CustomItemStack clone2 = new CustomItemStack(Utils.unKeyItem(displayItem), displayItem.getMaxStackSize());
                if (this.fits((DirtyChestMenu)inv, (ItemStack)clone2, this.OUTPUT_SLOTS)) {
                    int amount = clone2.getMaxStackSize();
                    this.setStored(b, stored - amount);
                    this.pushItem((DirtyChestMenu)inv, (ItemStack)clone2, this.OUTPUT_SLOTS);
                    this.updateMenu(b, inv, false, capacity);
                }
            } else if (stored != 0 && this.fits((DirtyChestMenu)inv, (ItemStack)(clone = new CustomItemStack(Utils.unKeyItem(displayItem), stored)), this.OUTPUT_SLOTS)) {
                this.setStored(b, 0);
                this.pushItem((DirtyChestMenu)inv, (ItemStack)clone, this.OUTPUT_SLOTS);
                this.updateMenu(b, inv, false, capacity);
            }
        }
    }

    private void registerItem(Block b, BlockMenu inv, int slot, ItemStack item, int capacity, int stored) {
        int amount = item.getAmount();
        inv.replaceExistingItem(31, (ItemStack)new CustomItemStack(Utils.keyItem(item), 1));
        if (amount <= capacity) {
            this.storeItem(b, inv, slot, item, capacity, stored);
        } else {
            amount = capacity;
            inv.consumeItem(slot, amount);
            this.setStored(b, stored + amount);
            this.updateMenu(b, inv, false, capacity);
        }
    }

    private void storeItem(Block b, BlockMenu inv, int slot, ItemStack item, int capacity, int stored) {
        int amount = item.getAmount();
        inv.consumeItem(slot, amount);
        this.setStored(b, stored + amount);
        this.updateMenu(b, inv, false, capacity);
    }

    private boolean matchMeta(ItemStack item1, ItemStack item2) {
        if (!item1.getType().equals((Object)item2.getType())) {
            return false;
        }
        if (!item1.hasItemMeta() && !item2.hasItemMeta()) {
            return true;
        }
        return item1.getItemMeta().equals(item2.getItemMeta());
    }

    public void updateMenu(Block b, BlockMenu inv, boolean force, int capacity) {
        String hasHolo = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"holo");
        int stored = this.getStored(b);
        String storedPercent = Barrel.doubleRoundAndFade((double)stored / (double)capacity * 100.0);
        String storedStacks = Barrel.doubleRoundAndFade((double)stored / (double)inv.getItemInSlot(31).getMaxStackSize());
        if (inv.hasViewer() || force) {
            inv.replaceExistingItem(22, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&6Items Stored: &e" + stored + " / " + capacity, new String[]{"&b" + storedStacks + " Stacks &8| &7" + storedPercent + "&7%"}));
        }
        String itemName = inv.getItemInSlot(31) != null && inv.getItemInSlot(31).getItemMeta().hasDisplayName() ? inv.getItemInSlot(31).getItemMeta().getDisplayName() : WordUtils.capitalizeFully((String)inv.getItemInSlot(31).getType().name().replace("_", " "));
        if (((Boolean)this.showHologram.getValue()).booleanValue() && (hasHolo == null || hasHolo.equals("true"))) {
            this.updateHologram(b, itemName, " &9x" + stored + " &7(" + storedPercent + "&7%)");
        }
        if (stored == 0) {
            inv.replaceExistingItem(31, (ItemStack)new CustomItemStack(Material.BARRIER, "&cEmpty", new String[0]));
            if (((Boolean)this.showHologram.getValue()).booleanValue() && (hasHolo == null || hasHolo.equals("true"))) {
                this.updateHologram(b, null, "&cEmpty");
            }
        }
    }

    private void toggleHolo(Block b, int capacity) {
        String toggle = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"holo");
        if (toggle == null || toggle.equals("true")) {
            this.putBlockData(b, 36, "holo", this.HOLOGRAM_OFF_ITEM, false);
            this.removeHologram(b);
        } else {
            this.putBlockData(b, 36, "holo", this.HOLOGRAM_ON_ITEM, true);
            this.updateMenu(b, BlockStorage.getInventory((Block)b), false, capacity);
        }
    }

    private void toggleTrash(Block b) {
        String toggle = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"trash");
        if (toggle == null || toggle.equals("false")) {
            this.putBlockData(b, 37, "trash", this.TRASH_ON_ITEM, true);
        } else {
            this.putBlockData(b, 37, "trash", this.TRASH_OFF_ITEM, false);
        }
    }

    private void putBlockData(Block b, int slot, String key, ItemStack displayItem, boolean data) {
        BlockStorage.addBlockInfo((Location)b.getLocation(), (String)key, (String)String.valueOf(data));
        BlockStorage.getInventory((Block)b).replaceExistingItem(slot, displayItem);
    }

    public void insertAll(Player p, BlockMenu menu, Block b) {
        ItemStack storedItem = Utils.unKeyItem(menu.getItemInSlot(31));
        PlayerInventory inv = p.getInventory();
        int capacity = this.getCapacity(b);
        int stored = this.getStored(b);
        for (int i = 0; i < inv.getContents().length; ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null) continue;
            int amount = item.getAmount();
            if (!this.matchMeta(item, storedItem) || stored + amount > capacity) continue;
            inv.setItem(i, null);
            stored += amount;
        }
        BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"stored", (String)String.valueOf(stored));
        this.updateMenu(b, menu, false, capacity);
    }

    public void extract(Player p, BlockMenu menu, Block b, ClickAction action) {
        ItemStack storedItem = this.getStoredItem(b);
        int capacity = this.getCapacity(b);
        PlayerInventory inv = p.getInventory();
        int stored = this.getStored(b);
        if (action.isRightClicked()) {
            if (stored > 0) {
                Utils.giveOrDropItem(p, (ItemStack)new CustomItemStack(storedItem));
                this.setStored(b, --stored);
                this.updateMenu(b, menu, false, capacity);
                return;
            }
            for (int slot : this.OUTPUT_SLOTS) {
                if (menu.getItemInSlot(slot) == null) continue;
                Utils.giveOrDropItem(p, (ItemStack)new CustomItemStack(menu.getItemInSlot(slot), 1));
                menu.consumeItem(slot);
                return;
            }
            Utils.send((CommandSender)p, "&cThis barrel is empty!");
            return;
        }
        if (storedItem.getType() == Material.BARRIER) {
            Utils.send((CommandSender)p, "&cThis barrel is empty!");
            return;
        }
        ItemStack[] contents = (ItemStack[])inv.getStorageContents().clone();
        int maxStackSize = storedItem.getMaxStackSize();
        int outI = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] != null) continue;
            if (stored >= maxStackSize) {
                inv.setItem(i, (ItemStack)new CustomItemStack(storedItem, maxStackSize));
                stored -= maxStackSize;
                continue;
            }
            if (stored > 0) {
                inv.setItem(i, (ItemStack)new CustomItemStack(storedItem, stored));
                stored = 0;
                continue;
            }
            if (outI > 1) break;
            ItemStack item = menu.getItemInSlot(this.OUTPUT_SLOTS[outI]);
            if (item == null) continue;
            inv.setItem(i, item.clone());
            menu.replaceExistingItem(this.OUTPUT_SLOTS[outI], null);
            ++outI;
        }
        this.setStored(b, stored);
        this.updateMenu(b, menu, false, capacity);
    }

    public static String doubleRoundAndFade(double num) {
        String formattedString = STORAGE_INDICATOR_FORMAT.format(num);
        if (formattedString.indexOf(46) != -1) {
            return formattedString.substring(0, formattedString.indexOf(46)) + ChatColor.DARK_GRAY + formattedString.substring(formattedString.indexOf(46)) + ChatColor.GRAY;
        }
        return formattedString;
    }

    public int getStored(Block b) {
        return Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"stored"));
    }

    public void setStored(Block b, int amount) {
        BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"stored", (String)String.valueOf(amount));
    }

    public ItemStack getStoredItem(Block b) {
        return Utils.unKeyItem(BlockStorage.getInventory((Block)b).getItemInSlot(31));
    }

    public int getCapacity(Block b) {
        return (Integer)this.barrelCapacity.getValue();
    }

    public static int getDisplayCapacity(BarrelType barrel) {
        int capacity = Slimefun.getItemCfg().getInt(barrel.getKey() + ".capacity");
        if (capacity == 0) {
            capacity = barrel.getDefaultSize();
        }
        return capacity;
    }

    @Override
    @Nonnull
    public Vector getHologramOffset(@Nonnull Block b) {
        return new Vector(0.5, 0.9, 0.5);
    }

    public static enum BarrelType {
        SMALL(17280000, "&eSmall Fluffy Barrel", Material.BEEHIVE, (ItemStack)SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.OAK_LOG)),
        MEDIUM(34560000, "&6Medium Fluffy Barrel", Material.BARREL, (ItemStack)SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.SMOOTH_STONE)),
        BIG(69120000, "&bBig Fluffy Barrel", Material.SMOKER, (ItemStack)SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.BRICKS)),
        LARGE(138240000, "&aLarge Fluffy Barrel", Material.LODESTONE, (ItemStack)SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.IRON_BLOCK)),
        MASSIVE(276480000, "&5Massive Fluffy Barrel", Material.CRYING_OBSIDIAN, (ItemStack)SlimefunItems.REINFORCED_PLATE, new ItemStack(Material.OBSIDIAN)),
        BOTTOMLESS(1728000000, "&cBottomless Fluffy Barrel", Material.RESPAWN_ANCHOR, (ItemStack)SlimefunItems.BLISTERING_INGOT_3, (ItemStack)SlimefunItems.REINFORCED_PLATE);

        private final int defaultSize;
        private final String displayName;
        private final Material itemMaterial;
        private final ItemStack reinforcement;
        private final ItemStack border;

        private BarrelType(int defaultSize, String displayName, Material itemMaterial, ItemStack reinforcement, ItemStack border) {
            this.defaultSize = defaultSize;
            this.displayName = displayName;
            this.itemMaterial = itemMaterial;
            this.reinforcement = reinforcement;
            this.border = border;
        }

        public int getDefaultSize() {
            return this.defaultSize;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Material getType() {
            return this.itemMaterial;
        }

        public String getKey() {
            return this.name().toUpperCase() + "_FLUFFY_BARREL";
        }

        public ItemStack getReinforcement() {
            return this.reinforcement;
        }

        public ItemStack getBorder() {
            return this.border;
        }
    }
}

