/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.flowerpower.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.flowerpower.FlowerPowerItems;
import io.ncbpfluffybear.flowerpower.multiblocks.MagicBasin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import utils.Constants;
import utils.ItemStackComparator;
import utils.Utils;

public class ExperienceCauldron
extends SlimefunItem
implements Listener {
    private static final int EXP_PER_LEVEL = 50;
    private static final MultiBlockMachine MAGIC_BASIN = (MultiBlockMachine)MagicBasin.BASIN_RECIPE.getMachine();
    private static final int MAX_CAULDRON_LEVEL = 3;

    public ExperienceCauldron(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        Utils.registerEvents(this);
    }

    @EventHandler(ignoreCancelled=true)
    private void onCauldronInteract(PlayerRightClickEvent e) {
        Optional optB = e.getClickedBlock();
        if (!optB.isPresent()) {
            return;
        }
        Block b = (Block)optB.get();
        SlimefunItem sfItem = BlockStorage.check((Block)b);
        if (sfItem == null || !this.isItem(sfItem.getItem())) {
            return;
        }
        if (b.getType() != Material.CAULDRON && b.getType() != Material.WATER_CAULDRON) {
            return;
        }
        if (e.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack handItem = p.getInventory().getItemInMainHand();
        int cauldronLevel = ExperienceCauldron.getCauldronLevel(b);
        if (handItem.getType() == Material.ITEM_FRAME) {
            return;
        }
        e.cancel();
        if (SlimefunUtils.isItemSimilar((ItemStack)handItem, (ItemStack)FlowerPowerItems.MAGICAL_WAND, (boolean)false, (boolean)false)) {
            if (cauldronLevel == 0) {
                Utils.send((CommandSender)p, "&cThis Experience Cauldron is out of experience!");
                return;
            }
            ArrayList<ItemFrame> itemFrames = new ArrayList<ItemFrame>();
            for (Entity en : b.getWorld().getNearbyEntities(b.getLocation(), 1.5, 1.0, 1.5)) {
                if (!(en instanceof ItemFrame) || itemFrames.size() >= 4) continue;
                itemFrames.add((ItemFrame)en);
            }
            if (itemFrames.size() != 4) {
                Utils.send((CommandSender)p, "&cYou need 4 item frames on each side of the Experience Cauldron");
                return;
            }
            ItemStack output = this.getOutput(ExperienceCauldron.getFrameItems(itemFrames));
            if (output != null) {
                ExperienceCauldron.craft(b, itemFrames, output);
                return;
            }
            Utils.send((CommandSender)p, "&cInvalid Recipe!");
            return;
        }
        int exp = Utils.getTotalExperience(p);
        if (p.isSneaking()) {
            if (cauldronLevel == 0) {
                Utils.send((CommandSender)p, "&cThis Experience Cauldron is already empty");
                return;
            }
            p.giveExp(50);
            ExperienceCauldron.changeLevel(b, -1);
            p.playSound(p.getLocation(), Sound.ITEM_BUCKET_FILL, 1.0f, 0.1f);
            return;
        }
        if (exp < 50) {
            Utils.send((CommandSender)p, "&cYou do not have enough exp to deposit");
            return;
        }
        if (cauldronLevel == 3) {
            Utils.send((CommandSender)p, "&cThis Experience Cauldron is full");
            return;
        }
        p.giveExp(-50);
        ExperienceCauldron.changeLevel(b, 1);
        p.playSound(p.getLocation(), Sound.ITEM_BUCKET_FILL, 1.0f, 1.0f);
    }

    @EventHandler(ignoreCancelled=true)
    private void onCauldronLevelChange(CauldronLevelChangeEvent e) {
        SlimefunItem sfItem = BlockStorage.check((Block)e.getBlock());
        if (sfItem != null && this.isItem(sfItem.getItem())) {
            e.setCancelled(true);
        }
    }

    private static void changeLevel(Block b, int i) {
        Material mat = b.getType();
        if (ExperienceCauldron.useNewCauldrons() && mat == Material.CAULDRON) {
            b.setType(Material.WATER_CAULDRON);
            Levelled cauldron = (Levelled)b.getBlockData();
            cauldron.setLevel(i);
            b.setBlockData((BlockData)cauldron);
        } else {
            Levelled cauldron = (Levelled)b.getBlockData();
            if (i == -1 && cauldron.getLevel() == 1 && ExperienceCauldron.useNewCauldrons()) {
                b.setType(Material.CAULDRON);
            } else {
                cauldron.setLevel(cauldron.getLevel() + i);
                b.setBlockData((BlockData)cauldron);
            }
        }
    }

    private static int getCauldronLevel(Block b) {
        Material mat = b.getType();
        if (ExperienceCauldron.useNewCauldrons()) {
            if (mat == Material.CAULDRON) {
                return 0;
            }
            if (mat == Material.WATER_CAULDRON) {
                Levelled cauldron = (Levelled)b.getBlockData();
                return cauldron.getLevel();
            }
        } else {
            Levelled cauldron = (Levelled)b.getBlockData();
            return cauldron.getLevel();
        }
        return 0;
    }

    private static boolean useNewCauldrons() {
        return Constants.SERVER_VERSION.contains("1.17") || Constants.SERVER_VERSION.contains("1.18") || Constants.SERVER_VERSION.contains("1.19") || Constants.SERVER_VERSION.contains("1.20");
    }

    private static List<ItemStack> getFrameItems(List<ItemFrame> itemFrames) {
        ArrayList<ItemStack> frameItems = new ArrayList<ItemStack>();
        for (ItemFrame frame : itemFrames) {
            ItemStack frameItem = frame.getItem();
            if (frameItem.getType() == Material.AIR) continue;
            SlimefunItem sfFrameItem = SlimefunItem.getByItem((ItemStack)frameItem);
            if (sfFrameItem != null) {
                frameItems.add(sfFrameItem.getItem());
                continue;
            }
            frameItems.add(frameItem);
        }
        return frameItems;
    }

    private static ItemStack checkRecipe(List<ItemStack> frameItems, ItemStack[] recipeInputs) {
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>(frameItems);
        ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
        for (ItemStack recipeItem : recipeInputs) {
            if (recipeItem == null) continue;
            recipeItems.add(recipeItem);
        }
        inputItems.sort(new ItemStackComparator());
        recipeItems.sort(new ItemStackComparator());
        if (inputItems.size() == recipeItems.size()) {
            for (int i = inputItems.size() - 1; i >= 0; --i) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)inputItems.get(i)), (ItemStack)((ItemStack)recipeItems.get(i)), (boolean)false, (boolean)true)) {
                    return null;
                }
                inputItems.remove(i);
                recipeItems.remove(i);
            }
        }
        if (inputItems.size() == 0 && recipeItems.size() == 0) {
            return RecipeType.getRecipeOutputList((MultiBlockMachine)MAGIC_BASIN, (ItemStack[])recipeInputs);
        }
        return null;
    }

    private ItemStack getOutput(List<ItemStack> frameItems) {
        for (ItemStack[] recipeInputs : RecipeType.getRecipeInputList((MultiBlockMachine)MAGIC_BASIN)) {
            ItemStack output = ExperienceCauldron.checkRecipe(frameItems, recipeInputs);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    private static void craft(Block b, List<ItemFrame> itemFrames, ItemStack output) {
        for (ItemFrame frame : itemFrames) {
            frame.setItem(new ItemStack(Material.AIR));
        }
        ExperienceCauldron.changeLevel(b, -1);
        b.getWorld().playSound(b.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 1.0f);
        Utils.runSync(() -> {
            b.getWorld().playEffect(b.getLocation(), Effect.POTION_BREAK, 1);
            b.getWorld().dropItem(b.getLocation().add(0.0, 1.0, 0.0), output);
        }, 20L);
    }
}

