/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.flowerpower.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.ncbpfluffybear.flowerpower.FlowerPowerPlugin;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import utils.Utils;

public class RecallCharm
extends SimpleSlimefunItem<ItemUseHandler> {
    public static final int TELEPORT_COST = 50;
    private static final int LORE_INDEX = 7;
    private static final NamespacedKey location = new NamespacedKey((Plugin)FlowerPowerPlugin.getInstance(), "location");

    public RecallCharm(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            if (e.getInteractEvent().getAction() == Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            Player p = e.getPlayer();
            ItemStack charm = e.getItem();
            ItemMeta charmMeta = charm.getItemMeta();
            if (p.isSneaking()) {
                Location l = p.getLocation();
                if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, l.getBlock(), Interaction.INTERACT_BLOCK)) {
                    Utils.send((CommandSender)p, "You do not have permission to bind your Recall Charm here!");
                    return;
                }
                PersistentDataAPI.setString((PersistentDataHolder)charmMeta, (NamespacedKey)location, (String)(l.getWorld().getUID() + "_" + l.getBlockX() + "_" + l.getBlockY() + "_" + l.getBlockZ()));
                List lore = charmMeta.getLore();
                lore.set(7, Utils.color("&3Bound Location: " + l.getWorld().getName() + " @ " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ()));
                charmMeta.setLore(lore);
                charm.setItemMeta(charmMeta);
                Utils.send((CommandSender)p, "&aYour recall charm has been bound to your current location");
                return;
            }
            if (Utils.getTotalExperience(p) < 50) {
                Utils.send((CommandSender)p, "&cYou can not afford to teleport! Needed exp points: 50");
                return;
            }
            String locationDat = PersistentDataAPI.getString((PersistentDataHolder)charmMeta, (NamespacedKey)location);
            if (locationDat == null) {
                Utils.send((CommandSender)p, "&cThis recall charm has not been bound yet!");
                return;
            }
            String[] location = locationDat.split("_");
            p.giveExp(-50);
            p.teleport(new Location(Bukkit.getWorld((UUID)UUID.fromString(location[0])), (double)Integer.parseInt(location[1]) + 0.5, (double)Integer.parseInt(location[2]), (double)Integer.parseInt(location[3]) + 0.5));
            p.playSound(p.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            Utils.send((CommandSender)p, "&aYou have teleported successfully");
        };
    }
}

