/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.flowerpower.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.ncbpfluffybear.flowerpower.objects.FPNotPlaceable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import utils.Utils;

public class InfinityBandage
extends SimpleSlimefunItem<ItemUseHandler>
implements FPNotPlaceable,
NotPlaceable {
    public static final double HEALTH_PER_CONSUME = 1.0;
    public static final int EXP_PER_CONSUME = 10;
    private final Map<Player, Long> cooldowns = new HashMap<Player, Long>();

    public InfinityBandage(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            long cooldown = this.cooldowns.getOrDefault(p, 0L);
            if (cooldown + 500L >= System.currentTimeMillis()) {
                Utils.send((CommandSender)p, "&cThis item is on cooldown!");
                return;
            }
            int exp = Utils.getTotalExperience(p);
            double health = p.getHealth();
            double maxHealth = p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            if (exp < 10) {
                Utils.send((CommandSender)p, "&cYou can not afford this! Needed exp points: 10");
                return;
            }
            if (health >= maxHealth) {
                Utils.send((CommandSender)p, "&cYour health is already full!");
                return;
            }
            p.giveExp(-10);
            double newHealth = health + 1.0;
            if (newHealth > maxHealth) {
                newHealth = maxHealth;
            }
            p.setHealth(newHealth);
            this.cooldowns.put(p, System.currentTimeMillis());
            p.playSound(p.getLocation(), Sound.ENTITY_CAT_HISS, 1.0f, 1.0f);
        };
    }

    public boolean isDisenchantable() {
        return false;
    }
}

