/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.flowerpower.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.ncbpfluffybear.flowerpower.FlowerPowerPlugin;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import utils.Utils;

public class ExperienceTome
extends SlimefunItem
implements Listener {
    private static final NamespacedKey expAmount = new NamespacedKey((Plugin)FlowerPowerPlugin.getInstance(), "exp-amount");
    private static final int MAX_EXP = 1000000;
    private static final int EXP_TRANSFER_RATE = 10;

    public ExperienceTome(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        Utils.registerEvents(this);
    }

    @EventHandler
    private void onTomeUse(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack tome = e.getItem();
        if (!this.isItem(tome)) {
            return;
        }
        if (!this.canUse(p, true)) {
            return;
        }
        e.setCancelled(true);
        if (tome == null) {
            return;
        }
        ItemMeta tomeMeta = tome.getItemMeta();
        int tomeExp = PersistentDataAPI.getInt((PersistentDataHolder)tomeMeta, (NamespacedKey)expAmount, (int)0);
        if (p.isSneaking()) {
            if (tomeExp == 0) {
                Utils.send((CommandSender)p, "&cThis Experience Tome is empty!");
                return;
            }
            int transferExp = e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_BLOCK ? tomeExp : Math.min(tomeExp, 10);
            PersistentDataAPI.setInt((PersistentDataHolder)tomeMeta, (NamespacedKey)expAmount, (int)(tomeExp -= transferExp));
            p.giveExp(transferExp);
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        } else {
            if (Utils.getTotalExperience(p) == 0) {
                Utils.send((CommandSender)p, "&cYou don't have enough exp!");
                return;
            }
            int transferExp = e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_BLOCK ? Utils.getTotalExperience(p) : Math.min(Utils.getTotalExperience(p), 10);
            if (transferExp + tomeExp > 1000000) {
                transferExp = 1000000 - tomeExp;
            }
            if (tomeExp + transferExp > 1000000 || transferExp == 0) {
                Utils.send((CommandSender)p, "&cThis Experience Tome is full!");
                return;
            }
            PersistentDataAPI.setInt((PersistentDataHolder)tomeMeta, (NamespacedKey)expAmount, (int)(tomeExp += transferExp));
            p.giveExp(-transferExp);
            p.playSound(p.getLocation(), Sound.ENTITY_DROWNED_AMBIENT_WATER, 1.0f, 1.0f);
        }
        tomeMeta.setDisplayName(Utils.color("&eExperience Tome &a(" + tomeExp + " / 1000000)"));
        tome.setItemMeta(tomeMeta);
    }
}

