/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.flowerpower.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.DoubleRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.ncbpfluffybear.flowerpower.FlowerPowerPlugin;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import utils.Utils;

public class AttributeCharms
extends SimpleSlimefunItem<ItemUseHandler>
implements Listener {
    private static final NamespacedKey inspectedKey = new NamespacedKey((Plugin)FlowerPowerPlugin.getInstance(), "inspected");
    private static final int LORE_INDEX = 1;
    private final ItemSetting<Double> minLevel;
    private final ItemSetting<Double> maxLevel;
    private final Charm type;

    public AttributeCharms(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Charm type) {
        super(category, item, recipeType, recipe);
        this.type = type;
        this.minLevel = new DoubleRangeSetting((SlimefunItem)this, "min-level", 0.0, type.minLvl, Double.MAX_VALUE);
        this.maxLevel = new DoubleRangeSetting((SlimefunItem)this, "max-level", 0.0, type.maxLvl, Double.MAX_VALUE);
        this.addItemSetting(new ItemSetting[]{this.minLevel, this.maxLevel});
        Utils.registerEvents(this);
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return e -> {
            ItemStack charm = e.getItem();
            ItemMeta charmMeta = charm.getItemMeta();
            Player p = e.getPlayer();
            if (PersistentDataAPI.getByte((PersistentDataHolder)charmMeta, (NamespacedKey)inspectedKey, (byte)0) == 1) {
                return;
            }
            double level = ThreadLocalRandom.current().nextDouble((Double)this.minLevel.getValue(), (Double)this.maxLevel.getValue());
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), this.type.attribute.getKey().getKey(), level, this.type.operation, EquipmentSlot.OFF_HAND);
            charmMeta.addAttributeModifier(this.type.attribute, modifier);
            List lore = charmMeta.getLore();
            lore.set(1, Utils.color("&aThis charm has been inspected"));
            charmMeta.setLore(lore);
            p.playSound(p.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 1.0f);
            PersistentDataAPI.setByte((PersistentDataHolder)charmMeta, (NamespacedKey)inspectedKey, (byte)1);
            charm.setItemMeta(charmMeta);
        };
    }

    public static enum Charm {
        MOVEMENT_SPEED(Attribute.GENERIC_MOVEMENT_SPEED, 0.01, 0.2, AttributeModifier.Operation.MULTIPLY_SCALAR_1),
        ATTACK_SPEED(Attribute.GENERIC_ATTACK_SPEED, 0.1, 0.5, AttributeModifier.Operation.MULTIPLY_SCALAR_1),
        FLY_SPEED(Attribute.GENERIC_FLYING_SPEED, 0.01, 1.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1),
        DAMAGE(Attribute.GENERIC_ATTACK_DAMAGE, 0.01, 1.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1),
        MAX_HEALTH(Attribute.GENERIC_MAX_HEALTH, 1.0, 5.0, AttributeModifier.Operation.ADD_NUMBER),
        KNOCKBACK_RESISTANCE(Attribute.GENERIC_KNOCKBACK_RESISTANCE, 0.1, 0.5, AttributeModifier.Operation.ADD_NUMBER);

        private final Attribute attribute;
        private final double minLvl;
        private final double maxLvl;
        private final AttributeModifier.Operation operation;

        private Charm(Attribute attribute, double minLvl, double maxLvl, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.minLvl = minLvl;
            this.maxLvl = maxLvl;
            this.operation = operation;
        }
    }
}

