/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.services;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.libs.guizhanlib.slimefun.addon.AddonConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eR\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u001e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/guizhanss/fastmachines/core/services/ConfigService;", "", "plugin", "Lnet/guizhanss/fastmachines/FastMachines;", "<init>", "(Lnet/guizhanss/fastmachines/FastMachines;)V", "value", "", "autoUpdate", "getAutoUpdate", "()Z", "debug", "getDebug", "", "lang", "getLang", "()Ljava/lang/String;", "enableResearches", "getEnableResearches", "", "fmTickRate", "getFmTickRate", "()I", "fmUseEnergy", "getFmUseEnergy", "fmRequireSfResearch", "getFmRequireSfResearch", "config", "Lnet/guizhanss/fastmachines/libs/guizhanlib/slimefun/addon/AddonConfig;", "reload", "", "FastMachines"})
public final class ConfigService {
    private boolean autoUpdate;
    private boolean debug;
    @NotNull
    private String lang;
    private boolean enableResearches;
    private int fmTickRate;
    private boolean fmUseEnergy;
    private boolean fmRequireSfResearch;
    @NotNull
    private final AddonConfig config;

    public ConfigService(@NotNull FastMachines plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.autoUpdate = true;
        this.lang = "en";
        this.enableResearches = true;
        this.fmTickRate = 10;
        this.fmUseEnergy = true;
        this.config = new AddonConfig(plugin, "config.yml");
        this.reload();
    }

    public final boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    public final boolean getEnableResearches() {
        return this.enableResearches;
    }

    public final int getFmTickRate() {
        return this.fmTickRate;
    }

    public final boolean getFmUseEnergy() {
        return this.fmUseEnergy;
    }

    public final boolean getFmRequireSfResearch() {
        return this.fmRequireSfResearch;
    }

    public final void reload() {
        this.config.reload();
        this.autoUpdate = this.config.getBoolean("auto-update", true);
        this.debug = this.config.getBoolean("debug", false);
        String string = this.config.getString("lang");
        if (string == null) {
            string = "en";
        }
        this.lang = string;
        this.enableResearches = this.config.getBoolean("enable-researches", true);
        this.fmTickRate = RangesKt.coerceIn((int)this.config.getInt("fast-machines.tick-rate", 10), (int)5, (int)600);
        this.fmUseEnergy = this.config.getBoolean("fast-machines.use-energy", true);
        this.fmRequireSfResearch = this.config.getBoolean("fast-machines.require-sf-research", false);
        this.config.save();
    }
}

