/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.recipes.choices;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.guizhanss.fastmachines.core.items.ItemWrapper;
import net.guizhanss.fastmachines.core.recipes.choices.RecipeChoice;
import net.guizhanss.fastmachines.utils.items.ItemExtKt;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\rH\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lnet/guizhanss/fastmachines/core/recipes/choices/ExactChoice;", "Lnet/guizhanss/fastmachines/core/recipes/choices/RecipeChoice;", "item", "Lnet/guizhanss/fastmachines/core/items/ItemWrapper;", "amount", "", "<init>", "(Lnet/guizhanss/fastmachines/core/items/ItemWrapper;I)V", "getItem", "()Lnet/guizhanss/fastmachines/core/items/ItemWrapper;", "getAmount", "()I", "choices", "", "getChoices", "()Ljava/util/Map;", "isValidItem", "", "Lorg/bukkit/inventory/ItemStack;", "maxCraftableAmount", "availableItems", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "", "FastMachines"})
public final class ExactChoice
implements RecipeChoice {
    @NotNull
    private final ItemWrapper item;
    private final int amount;
    @NotNull
    private final Map<ItemWrapper, Integer> choices;

    public ExactChoice(@NotNull ItemWrapper item, int amount) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.item = item;
        this.amount = amount;
        this.choices = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.item, (Object)this.amount));
    }

    public /* synthetic */ ExactChoice(ItemWrapper itemWrapper, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(itemWrapper, n);
    }

    @NotNull
    public final ItemWrapper getItem() {
        return this.item;
    }

    public final int getAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public Map<ItemWrapper, Integer> getChoices() {
        return this.choices;
    }

    @Override
    public boolean isValidItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return ItemExtKt.isSimilarTo$default(this.item, item, false, 2, null);
    }

    @Override
    public int maxCraftableAmount(@NotNull Map<ItemWrapper, Integer> availableItems) {
        Intrinsics.checkNotNullParameter(availableItems, (String)"availableItems");
        int available = ((Number)availableItems.getOrDefault(this.item, 0)).intValue();
        return available / this.amount;
    }

    @NotNull
    public final ItemWrapper component1() {
        return this.item;
    }

    public final int component2() {
        return this.amount;
    }

    @NotNull
    public final ExactChoice copy(@NotNull ItemWrapper item, int amount) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return new ExactChoice(item, amount);
    }

    public static /* synthetic */ ExactChoice copy$default(ExactChoice exactChoice, ItemWrapper itemWrapper, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            itemWrapper = exactChoice.item;
        }
        if ((n2 & 2) != 0) {
            n = exactChoice.amount;
        }
        return exactChoice.copy(itemWrapper, n);
    }

    @NotNull
    public String toString() {
        return "ExactChoice(item=" + this.item + ", amount=" + this.amount + ")";
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = result * 31 + Integer.hashCode(this.amount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExactChoice)) {
            return false;
        }
        ExactChoice exactChoice = (ExactChoice)other;
        if (!Intrinsics.areEqual((Object)this.item, (Object)exactChoice.item)) {
            return false;
        }
        return this.amount == exactChoice.amount;
    }
}

