/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.implementation.listeners.TranslationListener;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfiguration;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationDefaults;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationFields;
import net.guizhanss.slimefuntranslation.core.factories.MessageFactory;
import net.guizhanss.slimefuntranslation.utils.FileUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J3\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001a\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u001c"}, d2={"Lnet/guizhanss/fastmachines/core/services/IntegrationService;", "", "plugin", "Lnet/guizhanss/fastmachines/FastMachines;", "<init>", "(Lnet/guizhanss/fastmachines/FastMachines;)V", "infinityExpansionEnabled", "", "getInfinityExpansionEnabled", "()Z", "infinityExpansion2Enabled", "getInfinityExpansion2Enabled", "slimeFrameEnabled", "getSlimeFrameEnabled", "slimefunTranslationEnabled", "getSlimefunTranslationEnabled", "isEnabled", "pluginName", "", "loadTranslations", "", "sendMessage", "sender", "Lorg/bukkit/command/CommandSender;", "key", "args", "", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Ljava/lang/Object;)V", "FastMachines"})
public final class IntegrationService {
    @NotNull
    private final FastMachines plugin;
    private final boolean infinityExpansionEnabled;
    private final boolean infinityExpansion2Enabled;
    private final boolean slimeFrameEnabled;
    private final boolean slimefunTranslationEnabled;

    public IntegrationService(@NotNull FastMachines plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.infinityExpansionEnabled = this.isEnabled("InfinityExpansion");
        this.infinityExpansion2Enabled = this.isEnabled("InfinityExpansion2");
        this.slimeFrameEnabled = this.isEnabled("SlimeFrame");
        this.slimefunTranslationEnabled = this.isEnabled("SlimefunTranslation");
        if (this.slimefunTranslationEnabled) {
            new TranslationListener(this.plugin);
        }
    }

    public final boolean getInfinityExpansionEnabled() {
        return this.infinityExpansionEnabled;
    }

    public final boolean getInfinityExpansion2Enabled() {
        return this.infinityExpansion2Enabled;
    }

    public final boolean getSlimeFrameEnabled() {
        return this.slimeFrameEnabled;
    }

    public final boolean getSlimefunTranslationEnabled() {
        return this.slimefunTranslationEnabled;
    }

    private final boolean isEnabled(String pluginName) {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public final void loadTranslations() {
        TranslationConfigurationFields fields = TranslationConfigurationFields.builder().items("items").build();
        TranslationConfigurationDefaults defaults = TranslationConfigurationDefaults.builder().name("FastMachines").prefix("FM_").build();
        List list = FileUtils.listYamlFiles((File)new File(this.plugin.getDataFolder(), "lang"));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listYamlFiles(...)");
        List languages = list;
        for (String langFile : languages) {
            Optional cfg;
            YamlConfiguration fileConfig;
            File file = new File(this.plugin.getDataFolder(), "lang" + File.separator + langFile);
            Intrinsics.checkNotNull((Object)langFile);
            String lang = StringsKt.replace$default((String)langFile, (String)".yml", (String)"", (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)YamlConfiguration.loadConfiguration((File)file), (String)"loadConfiguration(...)");
            Intrinsics.checkNotNullExpressionValue((Object)TranslationConfiguration.fromFileConfiguration((String)lang, (FileConfiguration)((FileConfiguration)fileConfig), (TranslationConfigurationFields)fields, (TranslationConfigurationDefaults)defaults), (String)"fromFileConfiguration(...)");
            cfg.ifPresent(arg_0 -> IntegrationService.loadTranslations$lambda$1(arg_0 -> IntegrationService.loadTranslations$lambda$0(this, arg_0), arg_0));
        }
    }

    public final void sendMessage(@NotNull CommandSender sender, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        MessageFactory.get((Plugin)((Plugin)this.plugin)).sendMessage(sender, key, Arrays.copyOf(args, args.length));
    }

    private static final Unit loadTranslations$lambda$0(IntegrationService this$0, TranslationConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.register((SlimefunAddon)this$0.plugin);
        return Unit.INSTANCE;
    }

    private static final void loadTranslations$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

