/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.recipes.loaders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.RandomRecipe;
import net.guizhanss.fastmachines.core.recipes.Recipe;
import net.guizhanss.fastmachines.core.recipes.StandardRecipe;
import net.guizhanss.fastmachines.core.recipes.choices.RecipeChoice;
import net.guizhanss.fastmachines.core.recipes.raw.RawRecipe;
import net.guizhanss.fastmachines.implementation.items.machines.base.BaseFastMachine;
import net.guizhanss.fastmachines.utils.items.SlimefunItemExtKt;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lnet/guizhanss/fastmachines/core/recipes/loaders/RecipeLoader;", "", "machine", "Lnet/guizhanss/fastmachines/implementation/items/machines/base/BaseFastMachine;", "enableRandomRecipes", "", "<init>", "(Lnet/guizhanss/fastmachines/implementation/items/machines/base/BaseFastMachine;Z)V", "getMachine", "()Lnet/guizhanss/fastmachines/implementation/items/machines/base/BaseFastMachine;", "getEnableRandomRecipes", "()Z", "rawRecipes", "", "Lnet/guizhanss/fastmachines/core/recipes/raw/RawRecipe;", "getRawRecipes", "()Ljava/util/List;", "beforeLoad", "", "load", "loadWithRandomRecipes", "loadRecipes", "sortRecipes", "inputKey", "", "FastMachines"})
@SourceDebugExtension(value={"SMAP\nRecipeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeLoader.kt\nnet/guizhanss/fastmachines/core/recipes/loaders/RecipeLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,112:1\n1485#2:113\n1510#2,3:114\n1513#2,3:124\n1557#2:128\n1628#2,3:129\n774#2:132\n865#2,2:133\n1872#2,3:136\n1872#2,3:139\n1557#2:142\n1628#2,3:143\n381#3,7:117\n216#4:127\n217#4:135\n*S KotlinDebug\n*F\n+ 1 RecipeLoader.kt\nnet/guizhanss/fastmachines/core/recipes/loaders/RecipeLoader\n*L\n42#1:113\n42#1:114,3\n42#1:124,3\n49#1:128\n49#1:129,3\n49#1:132\n49#1:133,2\n72#1:136,3\n98#1:139,3\n104#1:142\n104#1:143,3\n42#1:117,7\n44#1:127\n44#1:135\n*E\n"})
public abstract class RecipeLoader {
    @NotNull
    private final BaseFastMachine machine;
    private final boolean enableRandomRecipes;
    @NotNull
    private final List<RawRecipe> rawRecipes;

    public RecipeLoader(@NotNull BaseFastMachine machine, boolean enableRandomRecipes) {
        Intrinsics.checkNotNullParameter((Object)((Object)machine), (String)"machine");
        this.machine = machine;
        this.enableRandomRecipes = enableRandomRecipes;
        this.rawRecipes = new ArrayList();
    }

    public /* synthetic */ RecipeLoader(BaseFastMachine baseFastMachine, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(baseFastMachine, bl);
    }

    @NotNull
    public final BaseFastMachine getMachine() {
        return this.machine;
    }

    public final boolean getEnableRandomRecipes() {
        return this.enableRandomRecipes;
    }

    @NotNull
    protected final List<RawRecipe> getRawRecipes() {
        return this.rawRecipes;
    }

    public void beforeLoad() {
    }

    public void load() {
        this.beforeLoad();
        FastMachines.Companion.debug("Loading recipes for " + this.machine.getId() + "...");
        if (this.enableRandomRecipes) {
            this.loadWithRandomRecipes();
        } else {
            this.loadRecipes();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadWithRandomRecipes() {
        Map groupedRecipes;
        void $this$groupByTo$iv$iv;
        this.sortRecipes();
        Iterable $this$groupBy$iv = this.rawRecipes;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            RawRecipe it = (RawRecipe)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = this.inputKey(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = groupedRecipes = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$filterTo$iv$iv;
            ItemStack it;
            Iterable $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String inputKey = (String)entry.getKey();
            List recipes = (List)entry.getValue();
            FastMachines.Companion.debug("===============");
            FastMachines.Companion.debug("Processing recipes with input key: " + inputKey);
            RecipeChoice input = (RecipeChoice)CollectionsKt.first(((RawRecipe)CollectionsKt.first((List)recipes)).getInputs());
            Iterable $this$map$iv = recipes;
            boolean $i$f$map = false;
            Iterable $i$f$getOrPut = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                RawRecipe rawRecipe = (RawRecipe)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getOutput());
            }
            Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ItemStack)element$iv$iv;
                boolean bl4 = false;
                if (!(!SlimefunItemExtKt.isDisabled(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List outputs = (List)destination$iv$iv2;
            if (outputs.isEmpty()) continue;
            FastMachines.Companion.debug("  - Input: " + input);
            FastMachines.Companion.debug("  - Outputs: " + outputs);
            Recipe recipe = outputs.size() > 1 ? (Recipe)new RandomRecipe(input, outputs) : (Recipe)new StandardRecipe(CollectionsKt.listOf((Object)input), (ItemStack)CollectionsKt.first((List)outputs));
            FastMachines.Companion.debug("  - Created recipe: " + recipe);
            this.machine.addRecipe(recipe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadRecipes() {
        this.sortRecipes();
        Iterable $this$forEachIndexed$iv = this.rawRecipes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void rawRecipe;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RawRecipe rawRecipe2 = (RawRecipe)item$iv;
            int index = n;
            boolean bl = false;
            FastMachines.Companion.debug("===============");
            FastMachines.Companion.debug("Processing raw recipe (" + (index + 1) + "/" + this.rawRecipes.size() + "): " + (RawRecipe)rawRecipe);
            if (rawRecipe.getOutput().size() > 1) {
                FastMachines.Companion.debug("  - Unexpected multiple outputs, skipping");
                continue;
            }
            ItemStack outputItem = (ItemStack)CollectionsKt.first(rawRecipe.getOutput());
            if (SlimefunItemExtKt.isDisabled(outputItem)) {
                FastMachines.Companion.debug("  - Output item is a disabled Slimefun item, skipping");
                continue;
            }
            StandardRecipe recipe = new StandardRecipe(rawRecipe.getInputs(), outputItem);
            FastMachines.Companion.debug("  - Created recipe: " + recipe);
            this.machine.addRecipe(recipe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sortRecipes() {
        CollectionsKt.sortWith(this.rawRecipes, (Comparator)new Comparator(this){
            final /* synthetic */ RecipeLoader this$0;
            {
                this.this$0 = recipeLoader2;
            }

            public final int compare(T a, T b) {
                RawRecipe it = (RawRecipe)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)RecipeLoader.access$inputKey(this.this$0, it));
                it = (RawRecipe)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)RecipeLoader.access$inputKey(this.this$0, it))));
            }
        });
        FastMachines.Companion.debug("Sorted raw recipes:");
        Iterable $this$forEachIndexed$iv = this.rawRecipes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void rawRecipe;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RawRecipe rawRecipe2 = (RawRecipe)item$iv;
            int index = n;
            boolean bl = false;
            FastMachines.Companion.debug("  (" + (index + 1) + "/" + this.rawRecipes.size() + "): " + (RawRecipe)rawRecipe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String inputKey(RawRecipe $this$inputKey) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$inputKey.getInputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void choice;
            RecipeChoice recipeChoice = (RecipeChoice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Function1[] function1Array = new Function1[]{RecipeLoader::inputKey$lambda$10$lambda$7, RecipeLoader::inputKey$lambda$10$lambda$8};
            collection.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)choice.getChoices().entrySet(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (CharSequence)",", null, null, (int)0, null, RecipeLoader::inputKey$lambda$10$lambda$9, (int)30, null));
        }
        List sortedInputChoices = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        return CollectionsKt.joinToString$default((Iterable)sortedInputChoices, (CharSequence)"||", null, null, (int)0, null, null, (int)62, null);
    }

    private static final Comparable inputKey$lambda$10$lambda$7(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)it.getKey();
    }

    private static final Comparable inputKey$lambda$10$lambda$8(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)it.getValue();
    }

    private static final CharSequence inputKey$lambda$10$lambda$9(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "x" + it.getValue();
    }

    public static final /* synthetic */ String access$inputKey(RecipeLoader $this, RawRecipe $receiver) {
        return $this.inputKey($receiver);
    }
}

