/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.libs.guizhanlib.slimefun.addon;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.fastmachines.libs.guizhanlib.localization.MinecraftLocalization;
import net.guizhanss.fastmachines.libs.guizhanlib.minecraft.utils.ItemUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlimefunLocalization
extends MinecraftLocalization {
    private static final String KEY_NAME = ".name";
    private static final String KEY_LORE = ".lore";
    private static final String MSG_KEY_NULL = "key cannot be null";
    private static final String MSG_ID_NULL = "id cannot be null";
    private static final String MSG_MATERIAL_NULL = "Material cannot be null";
    private static final String MSG_ITEMSTACK_NULL = "ItemStack cannot be null";
    private static final String MSG_TEXTURE_NULL = "Texture cannot be null";
    private String idPrefix = "";
    private String itemGroupKey = "categories";
    private String itemsKey = "items";
    private String recipesKey = "recipes";

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin) {
        super(plugin);
    }

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin, String folderName) {
        super(plugin, folderName);
    }

    @ParametersAreNonnullByDefault
    public SlimefunLocalization(JavaPlugin plugin, String folderName, String langFile) {
        super(plugin, folderName, langFile);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, Material material, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)MSG_MATERIAL_NULL);
        return ItemUtil.appendLore(new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), material, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE)), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, String texture, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((texture != null ? 1 : 0) != 0, (Object)MSG_TEXTURE_NULL);
        return ItemUtil.appendLore(new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), texture, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE)), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, ItemStack itemStack, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)MSG_ITEMSTACK_NULL);
        return ItemUtil.appendLore(new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), itemStack, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE)), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, Material material) {
        return this.getItemBy(this.itemGroupKey, id, material, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, String texture) {
        return this.getItemBy(this.itemGroupKey, id, texture, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, ItemStack itemStack) {
        return this.getItemBy(this.itemGroupKey, id, itemStack, new String[0]);
    }

    public SlimefunItemStack getItem(String id, Material material, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, material, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, String texture, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, texture, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, ItemStack itemStack, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, itemStack, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, Material material, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, material, extraLore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, String texture, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, texture, extraLore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, ItemStack itemStack, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, itemStack, extraLore));
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setItemGroupKey(String itemGroupKey) {
        this.itemGroupKey = itemGroupKey;
    }

    public void setItemsKey(String itemsKey) {
        this.itemsKey = itemsKey;
    }

    public void setRecipesKey(String recipesKey) {
        this.recipesKey = recipesKey;
    }
}

