/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.items.machines.abstracts;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.core.recipes.RandomRecipe;
import net.guizhanss.fastmachines.guizhanlib.minecraft.utils.ItemUtil;
import net.guizhanss.fastmachines.guizhanlib.slimefun.machines.TickingMenuBlock;
import net.guizhanss.fastmachines.setup.Groups;
import net.guizhanss.fastmachines.utils.BlockStorageUtils;
import net.guizhanss.fastmachines.utils.Heads;
import net.guizhanss.fastmachines.utils.Keys;
import net.guizhanss.fastmachines.utils.MachineUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public abstract class AbstractFastMachine
extends TickingMenuBlock
implements EnergyNetComponent {
    protected static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    protected static final int[] OUTPUT_SLOTS = new int[]{27, 28, 29, 30, 31, 32, 33, 34, 35, 18, 19, 20, 21, 22, 23, 24, 25, 26, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    protected static final int[] PREVIEW_SLOTS = new int[]{36, 37, 38, 39, 40, 41, 45, 46, 47, 48, 49, 50};
    protected static final int SCROLL_UP_SLOT = 42;
    protected static final int SCROLL_DOWN_SLOT = 51;
    protected static final int CHOICE_SLOT = 52;
    protected static final int CRAFT_SLOT = 53;
    protected static final int CHOICE_INDICATOR_SLOT = 43;
    protected static final int INFO_SLOT = 44;
    protected static final int ITEMS_PER_PAGE = PREVIEW_SLOTS.length;
    protected static final String KEY_CHOICE = "choice";
    protected static final ItemStack SCROLL_UP_ITEM = FastMachines.getLocalization().getItem("SCROLL_UP", Heads.ARROW_UP.getTexture(), new String[0]);
    protected static final ItemStack SCROLL_DOWN_ITEM = FastMachines.getLocalization().getItem("SCROLL_DOWN", Heads.ARROW_DOWN.getTexture(), new String[0]);
    protected static final ItemStack CHOICE_INDICATOR_ITEM = FastMachines.getLocalization().getItem("CHOICE_INDICATOR", Material.YELLOW_STAINED_GLASS_PANE, new String[0]);
    protected static final ItemStack INFO_ITEM = FastMachines.getLocalization().getItem("INFO", Heads.INFO.getTexture(), new String[0]);
    protected static final ItemStack NO_ITEM = FastMachines.getLocalization().getItem("NO_ITEM", Material.BARRIER, new String[0]);
    protected static final Map<BlockPosition, Map<IRecipe, Integer>> OUTPUTS_MAP = new HashMap<BlockPosition, Map<IRecipe, Integer>>();
    protected final List<IRecipe> recipes = new ArrayList<IRecipe>();

    @ParametersAreNonnullByDefault
    protected AbstractFastMachine(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)Groups.MACHINES, item, recipeType, recipe);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public abstract int getEnergyPerUse();

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        for (int slot : PREVIEW_SLOTS) {
            preset.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(43, CHOICE_INDICATOR_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(44, INFO_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(52, NO_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(42, SCROLL_UP_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(51, SCROLL_DOWN_ITEM, ChestMenuUtils.getEmptyClickHandler());
        ItemStack craftItem = ItemUtil.appendLore(this.getCraftItem(), "", LoreBuilder.power((int)this.getEnergyPerUse(), (String)FastMachines.getLocalization().getString("lores.per-craft")));
        preset.addItem(53, craftItem, ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onNewInstance(BlockMenu blockMenu, Block block) {
        BlockPosition pos = new BlockPosition(block);
        blockMenu.addMenuClickHandler(42, (player, i, itemStack, clickAction) -> {
            int currentPage = BlockStorageUtils.getInt(pos, "page", 1);
            BlockStorageUtils.setInt(pos, "page", currentPage - 1);
            this.updateMenu(blockMenu);
            return false;
        });
        blockMenu.addMenuClickHandler(51, (player, i, itemStack, clickAction) -> {
            int currentPage = BlockStorageUtils.getInt(pos, "page", 1);
            BlockStorageUtils.setInt(pos, "page", currentPage + 1);
            this.updateMenu(blockMenu);
            return false;
        });
        blockMenu.addMenuClickHandler(53, (player, i, itemStack, clickAction) -> {
            if (clickAction.isShiftClicked()) {
                if (clickAction.isRightClicked()) {
                    this.craft(blockMenu, player, Integer.MAX_VALUE);
                } else {
                    this.craft(blockMenu, player, 64);
                }
            } else if (clickAction.isRightClicked()) {
                this.craft(blockMenu, player, 16);
            } else {
                this.craft(blockMenu, player, 1);
            }
            return false;
        });
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void tick(Block block, BlockMenu blockMenu) {
        if (blockMenu.hasViewer() && FastMachines.getSlimefunTickCount() % 2 == 0) {
            this.findAvailableOutputs(blockMenu);
            this.updateMenu(blockMenu);
        }
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    public void register(@Nonnull SlimefunAddon addon) {
        super.register(addon);
        FastMachines.getScheduler().run(2, this::registerRecipes);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        Location l = menu.getLocation();
        menu.dropItems(l, INPUT_SLOTS);
    }

    @Nonnull
    protected Map<IRecipe, Integer> getMachineOutputs(@Nonnull BlockMenu menu) {
        BlockPosition pos = new BlockPosition(menu.getLocation());
        Map outputs = OUTPUTS_MAP.getOrDefault(pos, new LinkedHashMap());
        OUTPUTS_MAP.put(pos, outputs);
        return outputs;
    }

    @ParametersAreNonnullByDefault
    protected void findAvailableOutputs(BlockMenu blockMenu) {
        BlockPosition pos = new BlockPosition(blockMenu.getLocation());
        Map<ItemStack, Integer> machineInputs = MachineUtils.getMachineInputAmount(blockMenu, INPUT_SLOTS);
        Map<IRecipe, Integer> outputs = this.getMachineOutputs(blockMenu);
        outputs.clear();
        if (machineInputs.isEmpty()) {
            return;
        }
        FastMachines.debug("current machine: {0}, location: {1}", ((Object)((Object)this)).getClass().getSimpleName(), pos);
        FastMachines.debug("machine inputs: {0}", machineInputs);
        for (IRecipe recipe : this.recipes) {
            if (recipe.isDisabledInWorld(pos.getWorld())) continue;
            FastMachines.debug("checking recipe: {0}", recipe);
            int outputAmount = Integer.MAX_VALUE;
            for (Map.Entry<ItemStack, Integer> recipeInputEntry : recipe.getInput().entrySet()) {
                if (!machineInputs.containsKey(recipeInputEntry.getKey())) {
                    outputAmount = 0;
                    break;
                }
                FastMachines.debug("input: {0}, machine amount: {1}", recipeInputEntry.getKey(), machineInputs.get(recipeInputEntry.getKey()));
                FastMachines.debug("recipe amount: {0}", recipeInputEntry.getValue());
                int inputAmount = machineInputs.get(recipeInputEntry.getKey());
                int recipeAmount = recipeInputEntry.getValue();
                outputAmount = Math.min(outputAmount, inputAmount / recipeAmount);
                FastMachines.debug("result amount: {0}", inputAmount / recipeAmount);
            }
            if (outputAmount <= 0) continue;
            FastMachines.debug("recipe is available, output amount: {0}", outputAmount);
            outputs.put(recipe, outputAmount);
        }
        FastMachines.debug("outputs: " + outputs, new Object[0]);
    }

    @ParametersAreNonnullByDefault
    protected void updateMenu(BlockMenu blockMenu) {
        BlockPosition pos = new BlockPosition(blockMenu.getLocation());
        Map<IRecipe, Integer> outputs = this.getMachineOutputs(blockMenu);
        ItemStack[] outputItems = (ItemStack[])outputs.keySet().stream().map(recipe -> recipe.getOutput(pos.getWorld())).toArray(ItemStack[]::new);
        int currentPage = BlockStorageUtils.getInt(pos, "page", 1);
        int totalPages = (int)Math.ceil((double)outputs.size() * 1.0 / (double)ITEMS_PER_PAGE);
        if (currentPage < 1) {
            currentPage = 1;
            BlockStorageUtils.setInt(pos, "page", 1);
        }
        if (currentPage > totalPages) {
            currentPage = totalPages;
            BlockStorageUtils.setInt(pos, "page", totalPages);
        }
        for (int i = 0; i < ITEMS_PER_PAGE; ++i) {
            int index = (currentPage - 1) * ITEMS_PER_PAGE + i;
            if (totalPages == 0 || index >= outputs.size()) {
                blockMenu.replaceExistingItem(PREVIEW_SLOTS[i], ChestMenuUtils.getBackground());
                blockMenu.addMenuClickHandler(PREVIEW_SLOTS[i], ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            ItemStack output = this.getDisplayItem(outputItems[index]);
            blockMenu.replaceExistingItem(PREVIEW_SLOTS[i], output);
            blockMenu.addMenuClickHandler(PREVIEW_SLOTS[i], (player, slot, itemStack, clickAction) -> {
                BlockStorageUtils.setInt(pos, KEY_CHOICE, index);
                this.updateChoice(blockMenu);
                return false;
            });
        }
        this.updateChoice(blockMenu);
    }

    @ParametersAreNonnullByDefault
    protected void updateChoice(BlockMenu blockMenu) {
        BlockPosition pos = new BlockPosition(blockMenu.getLocation());
        Map<IRecipe, Integer> outputs = this.getMachineOutputs(blockMenu);
        ItemStack[] outputItems = (ItemStack[])outputs.keySet().stream().map(recipe -> recipe.getOutput(pos.getWorld())).toArray(ItemStack[]::new);
        int choice = BlockStorageUtils.getInt(pos, KEY_CHOICE);
        if (choice >= outputs.size()) {
            blockMenu.replaceExistingItem(52, NO_ITEM);
        } else {
            ItemStack output = this.getDisplayItem(outputItems[choice]);
            blockMenu.replaceExistingItem(52, output);
        }
    }

    @ParametersAreNonnullByDefault
    protected void craft(BlockMenu blockMenu, Player p, int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"amount must greater than 0");
        BlockPosition pos = new BlockPosition(blockMenu.getLocation());
        Map<IRecipe, Integer> outputs = this.getMachineOutputs(blockMenu);
        List outputRecipes = outputs.entrySet().stream().toList();
        int choice = BlockStorageUtils.getInt(pos, KEY_CHOICE);
        if (choice >= outputs.size()) {
            return;
        }
        Map.Entry recipe = (Map.Entry)outputRecipes.get(choice);
        int maxAmount = (Integer)recipe.getValue();
        amount = Math.min(maxAmount, amount);
        if (FastMachines.getAddonConfig().getBoolean("fast-machines.use-energy")) {
            int energyNeeded = this.getEnergyPerUse() * amount;
            int currentEnergy = this.getCharge(blockMenu.getLocation());
            if (currentEnergy < energyNeeded) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-energy", new Object[0]);
                return;
            }
            this.setCharge(blockMenu.getLocation(), currentEnergy - energyNeeded);
        }
        for (Map.Entry<ItemStack, Integer> inputEntry : ((IRecipe)recipe.getKey()).getInput().entrySet()) {
            int requiredAmount = inputEntry.getValue() * amount;
            Pair<List<Integer>, Integer> itemAmount = MachineUtils.getItemAmount(blockMenu, INPUT_SLOTS, inputEntry.getKey());
            if ((Integer)itemAmount.getSecondValue() < requiredAmount) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-materials", new Object[0]);
                return;
            }
            MachineUtils.removeItems(blockMenu, ((List)itemAmount.getFirstValue()).stream().mapToInt(Integer::intValue).toArray(), inputEntry.getKey(), requiredAmount);
        }
        Object inputEntry = recipe.getKey();
        if (inputEntry instanceof RandomRecipe) {
            RandomRecipe randomRecipe = (RandomRecipe)inputEntry;
            boolean machineFull = false;
            for (int i = 0; i < amount; ++i) {
                ItemStack product = randomRecipe.getOutput(pos.getWorld()).clone();
                if (!MachineUtils.addItem(p, blockMenu, OUTPUT_SLOTS, product, 1)) continue;
                machineFull = true;
            }
            if (machineFull) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-space", new Object[0]);
            }
        } else {
            ItemStack product = ((IRecipe)recipe.getKey()).getOutput(pos.getWorld()).clone();
            if (MachineUtils.addItem(p, blockMenu, OUTPUT_SLOTS, product, amount)) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-space", new Object[0]);
            }
        }
    }

    @Nonnull
    protected ItemStack getDisplayItem(@Nonnull ItemStack item) {
        ItemStack newItem = item.clone();
        ItemMeta meta = newItem.getItemMeta();
        PersistentDataAPI.setBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.get("display"), (boolean)true);
        newItem.setItemMeta(meta);
        return newItem;
    }

    protected abstract void registerRecipes();

    protected abstract ItemStack getCraftItem();
}

