/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.utils;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.core.recipes.RandomRecipe;
import net.guizhanss.fastmachines.core.recipes.RawRecipe;
import net.guizhanss.fastmachines.core.recipes.StandardRecipe;
import net.guizhanss.fastmachines.utils.SlimefunItemUtils;
import org.bukkit.Material;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public final class RecipeUtils {
    private static final String MSG_ID_NULL = "id cannot be null";
    private static final String MSG_RECIPE_NULL = "recipes cannot be null";
    private static final Comparator<ItemStack> ITEM_COMPARATOR = (aItem, bItem) -> {
        if (aItem == null && bItem == null) {
            return 0;
        }
        if (aItem == null) {
            return -1;
        }
        if (bItem == null) {
            return 1;
        }
        if (RecipeUtils.isItemSimilar(aItem, bItem)) {
            return 0;
        }
        if (Objects.hashCode(aItem) != Objects.hashCode(bItem)) {
            return Objects.hashCode(aItem) - Objects.hashCode(bItem);
        }
        if (aItem.getAmount() != bItem.getAmount()) {
            return aItem.getAmount() - bItem.getAmount();
        }
        return 0;
    };

    @ParametersAreNonnullByDefault
    private static boolean isItemSimilar(ItemStack aItem, ItemStack bItem) {
        if (aItem.getType() == Material.SPAWNER && bItem.getType() == Material.SPAWNER) {
            return SlimefunUtils.isItemSimilar((ItemStack)aItem, (ItemStack)bItem, (boolean)true, (boolean)true, (boolean)true);
        }
        return SlimefunUtils.isItemSimilar((ItemStack)aItem, (ItemStack)bItem, (boolean)false, (boolean)true, (boolean)true);
    }

    public static Map<ItemStack, Integer> calculateItems(ItemStack ... items) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            if (item == null || item.getType().isAir()) continue;
            boolean existingItem = false;
            for (Map.Entry entry : result.entrySet()) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)item, (ItemStack)((ItemStack)entry.getKey()), (boolean)false, (boolean)false, (boolean)true)) continue;
                existingItem = true;
                result.put((ItemStack)entry.getKey(), (Integer)entry.getValue() + item.getAmount());
                break;
            }
            if (existingItem) continue;
            ItemStack itemCopy = item.clone();
            itemCopy.setAmount(1);
            result.put(itemCopy, item.getAmount());
        }
        return result;
    }

    private static boolean appendRandomRecipe(List<IRecipe> recipes, ItemStack input, List<ItemStack> output) {
        for (IRecipe recipe : recipes) {
            RandomRecipe randomRecipe;
            IRecipe iRecipe = recipe;
            if (!(iRecipe instanceof RandomRecipe) || !SlimefunUtils.isItemSimilar((ItemStack)input, (ItemStack)(randomRecipe = (RandomRecipe)iRecipe).getRawInput(), (boolean)false, (boolean)true, (boolean)true)) continue;
            FastMachines.debug("existing random recipe found: {0}, adding more items: {1}", randomRecipe, output);
            randomRecipe.addOutput(output);
            return true;
        }
        return false;
    }

    public static void registerRecipes(List<IRecipe> recipes, List<RawRecipe> pendingRecipes) {
        Object[] lastInput = new ItemStack[]{};
        ArrayList<ItemStack> storedOutput = new ArrayList<ItemStack>();
        for (int tries = 0; tries < 3; ++tries) {
            try {
                pendingRecipes.sort((a, b) -> {
                    int result = Arrays.compare(a.input(), b.input(), ITEM_COMPARATOR);
                    if (result != 0) {
                        return result;
                    }
                    return Arrays.compare(a.output(), b.output(), ITEM_COMPARATOR);
                });
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        FastMachines.debug("raw recipes: {0}", pendingRecipes);
        for (RawRecipe recipe : pendingRecipes) {
            Object[] input = recipe.input();
            Object[] output = recipe.output();
            FastMachines.debug("--------------------", new Object[0]);
            if (input == null || output == null) {
                FastMachines.log(Level.WARNING, "Unexpected empty input/output", new Object[0]);
                continue;
            }
            if (output.length != 1) {
                FastMachines.log(Level.WARNING, "Unexpected multiple output items from recipe, ignoring. input: {0}, output: {1}", input, output);
                continue;
            }
            if (SlimefunItemUtils.isDisabled(output[0])) continue;
            FastMachines.debug("processing raw recipe: input={0}, output={1}", Arrays.toString(input), Arrays.toString(output));
            if (Arrays.equals(input, lastInput, ITEM_COMPARATOR)) {
                FastMachines.debug("input matches last recipe, adding to stored output", new Object[0]);
                storedOutput.add((ItemStack)output[0]);
                continue;
            }
            if (storedOutput.isEmpty()) {
                FastMachines.debug("empty output, storing current recipe", new Object[0]);
                lastInput = input;
                storedOutput.add((ItemStack)output[0]);
                continue;
            }
            RecipeUtils.registerRecipeHelper(recipes, lastInput, storedOutput);
            lastInput = input;
            storedOutput.clear();
            storedOutput.add((ItemStack)output[0]);
        }
        RecipeUtils.registerRecipeHelper(recipes, lastInput, storedOutput);
    }

    private static void registerRecipeHelper(List<IRecipe> recipes, ItemStack[] lastInput, List<ItemStack> storedOutput) {
        if (!RecipeUtils.appendRandomRecipe(recipes, lastInput[0], storedOutput)) {
            IRecipe iRecipe;
            if (storedOutput.size() > 1) {
                iRecipe = new RandomRecipe(lastInput[0], storedOutput);
                FastMachines.debug("registering random recipe: {0}", iRecipe);
            } else {
                iRecipe = new StandardRecipe(storedOutput.get(0), lastInput);
                FastMachines.debug("registering standard recipe: {0}", iRecipe);
            }
            recipes.add(iRecipe);
        }
    }

    @ParametersAreNonnullByDefault
    public static void registerMultiblockMachineRecipes(List<IRecipe> recipes, String id) {
        SlimefunItem machineItem;
        Preconditions.checkArgument((recipes != null ? 1 : 0) != 0, (Object)MSG_RECIPE_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        SlimefunItem slimefunItem = machineItem = SlimefunItem.getById((String)id);
        if (!(slimefunItem instanceof MultiBlockMachine)) {
            throw new IllegalArgumentException("must be a multiblock machine");
        }
        MultiBlockMachine machine = (MultiBlockMachine)slimefunItem;
        List recipeList = machine.getRecipes();
        if (recipeList.size() % 2 != 0) {
            throw new IllegalArgumentException("The given MultiBlockMachine has illegal recipe list: " + id);
        }
        FastMachines.debug("Registering recipes from multiblock: {0}", id);
        FastMachines.debug("Expected total recipes: {0}", recipeList.size() / 2);
        ArrayList<RawRecipe> pendingRecipes = new ArrayList<RawRecipe>();
        for (int i = 0; i < recipeList.size(); i += 2) {
            ItemStack[] input = (ItemStack[])recipeList.get(i);
            ItemStack[] output = (ItemStack[])recipeList.get(i + 1);
            pendingRecipes.add(new RawRecipe(input, output));
        }
        RecipeUtils.registerRecipes(recipes, pendingRecipes);
    }

    @ParametersAreNonnullByDefault
    public static void registerMachineRecipes(List<IRecipe> recipes, String id) {
        Preconditions.checkArgument((recipes != null ? 1 : 0) != 0, (Object)MSG_RECIPE_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        SlimefunItem machineItem = SlimefunItem.getById((String)id);
        if (machineItem == null) {
            throw new IllegalArgumentException("The given id is not a valid SlimefunItem: " + id);
        }
        FastMachines.debug("Registering recipes from machine: {0}", id);
        try {
            Method method = machineItem.getClass().getMethod("getMachineRecipes", new Class[0]);
            List machineRecipes = (List)method.invoke((Object)machineItem, new Object[0]);
            if (machineRecipes == null) {
                FastMachines.debug("Retrieved recipes are null, ignoring.", new Object[0]);
                return;
            }
            ArrayList<RawRecipe> pendingRecipes = new ArrayList<RawRecipe>();
            for (MachineRecipe machineRecipe : machineRecipes) {
                ItemStack[] input = machineRecipe.getInput();
                ItemStack[] output = machineRecipe.getOutput();
                if (output.length <= 0) continue;
                pendingRecipes.add(new RawRecipe(input, output));
            }
            RecipeUtils.registerRecipes(recipes, pendingRecipes);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FastMachines.log(Level.WARNING, "Failed to retrieve machine recipes from {0}, attempting to use backup method.", id);
            SlimefunItem slimefunItem = machineItem;
            if (slimefunItem instanceof RecipeDisplayItem) {
                RecipeDisplayItem recipeDisplayItem = (RecipeDisplayItem)slimefunItem;
                RecipeUtils.registerDisplayRecipes(recipes, recipeDisplayItem.getDisplayRecipes());
                FastMachines.log(Level.INFO, "Backup method succeeded. You can ignore the above warning.", new Object[0]);
            }
            FastMachines.log(Level.SEVERE, "Backup method failed, please report this.", new Object[0]);
        }
    }

    public static void registerDisplayRecipes(List<IRecipe> recipes, String id) {
        Preconditions.checkArgument((recipes != null ? 1 : 0) != 0, (Object)MSG_RECIPE_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        SlimefunItem sfItem = SlimefunItem.getById((String)id);
        if (sfItem == null) {
            throw new IllegalArgumentException("The given id is not a valid SlimefunItem: " + id);
        }
        SlimefunItem slimefunItem = sfItem;
        if (!(slimefunItem instanceof RecipeDisplayItem)) {
            throw new IllegalArgumentException("The given item is not a valid RecipeDisplayItem: " + id);
        }
        RecipeDisplayItem recipeDisplayItem = (RecipeDisplayItem)slimefunItem;
        FastMachines.debug("Registering recipes from display recipes: {0}", id);
        RecipeUtils.registerDisplayRecipes(recipes, recipeDisplayItem.getDisplayRecipes());
    }

    @ParametersAreNonnullByDefault
    public static void registerDisplayRecipes(List<IRecipe> recipes, List<ItemStack> displayRecipes) {
        Preconditions.checkArgument((recipes != null ? 1 : 0) != 0, (Object)MSG_RECIPE_NULL);
        Preconditions.checkArgument((displayRecipes != null ? 1 : 0) != 0, (Object)"displayRecipes cannot be null");
        if (displayRecipes.size() % 2 != 0) {
            throw new IllegalArgumentException("The display recipes list is illegal!");
        }
        FastMachines.debug("Expected total recipes: {0}", displayRecipes.size() / 2);
        ArrayList<RawRecipe> pendingRecipes = new ArrayList<RawRecipe>();
        for (int i = 0; i < displayRecipes.size(); i += 2) {
            ItemStack[] input = new ItemStack[]{displayRecipes.get(i)};
            ItemStack[] output = new ItemStack[]{displayRecipes.get(i + 1)};
            pendingRecipes.add(new RawRecipe(input, output));
        }
        RecipeUtils.registerRecipes(recipes, pendingRecipes);
    }

    @ParametersAreNonnullByDefault
    public static void registerVanillaRecipes(List<IRecipe> recipes, Class<? extends Recipe> recipeClass) {
        Iterator iterator = FastMachines.getInstance().getServer().recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = (Recipe)iterator.next();
            if (!recipeClass.isInstance(recipe)) continue;
            RecipeUtils.registerVanillaRecipe(recipes, recipe);
        }
    }

    private static <T extends Recipe> void registerVanillaRecipe(List<IRecipe> recipes, T recipe) {
        StandardRecipe iRecipe = null;
        T t = recipe;
        if (t instanceof ShapedRecipe) {
            char[] shape;
            ShapedRecipe shapedRecipe = (ShapedRecipe)t;
            ArrayList<ItemStack> ingredientList = new ArrayList<ItemStack>();
            Map ingredients = shapedRecipe.getIngredientMap();
            StringBuilder shapeR = new StringBuilder();
            for (String shapeLine : shapedRecipe.getShape()) {
                shapeR.append(shapeLine.replaceAll(" ", ""));
            }
            for (char i : shape = shapeR.toString().toCharArray()) {
                ingredientList.add((ItemStack)ingredients.get(Character.valueOf(i)));
            }
            iRecipe = new StandardRecipe(shapedRecipe.getResult(), ingredientList);
            FastMachines.debug("registering standard recipe: {0}", iRecipe);
        } else {
            t = recipe;
            if (t instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)t;
                iRecipe = new StandardRecipe(shapelessRecipe.getResult(), shapelessRecipe.getIngredientList());
                FastMachines.debug("registering standard recipe: {0}", iRecipe);
            } else {
                t = recipe;
                if (t instanceof CookingRecipe) {
                    CookingRecipe cookingRecipe = (CookingRecipe)t;
                    iRecipe = new StandardRecipe(cookingRecipe.getResult(), cookingRecipe.getInput());
                    FastMachines.debug("registering standard recipe: {0}", iRecipe);
                }
            }
        }
        if (iRecipe != null) {
            recipes.add(iRecipe);
        }
    }

    private RecipeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

