/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.recipes;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.guizhanss.fastmachines.core.recipes.Recipe;
import net.guizhanss.fastmachines.core.recipes.choices.RecipeChoice;
import net.guizhanss.fastmachines.utils.items.SlimefunItemExtKt;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c2\u0003J#\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/guizhanss/fastmachines/core/recipes/StandardRecipe;", "Lnet/guizhanss/fastmachines/core/recipes/Recipe;", "inputs", "", "Lnet/guizhanss/fastmachines/core/recipes/choices/RecipeChoice;", "output", "Lorg/bukkit/inventory/ItemStack;", "<init>", "(Ljava/util/List;Lorg/bukkit/inventory/ItemStack;)V", "getInputs", "()Ljava/util/List;", "outputs", "getOutputs", "getOutput", "world", "Lorg/bukkit/World;", "isDisabledIn", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "FastMachines"})
public final class StandardRecipe
implements Recipe {
    @NotNull
    private final List<RecipeChoice> inputs;
    @NotNull
    private final ItemStack output;
    @NotNull
    private final List<ItemStack> outputs;

    public StandardRecipe(@NotNull List<? extends RecipeChoice> inputs, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.inputs = inputs;
        this.output = output;
        this.outputs = CollectionsKt.listOf((Object)this.output);
    }

    @Override
    @NotNull
    public List<RecipeChoice> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    @NotNull
    public ItemStack getOutput(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.output;
    }

    @Override
    public boolean isDisabledIn(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return SlimefunItemExtKt.isDisabledIn(this.output, world);
    }

    @NotNull
    public final List<RecipeChoice> component1() {
        return this.inputs;
    }

    private final ItemStack component2() {
        return this.output;
    }

    @NotNull
    public final StandardRecipe copy(@NotNull List<? extends RecipeChoice> inputs, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new StandardRecipe(inputs, output);
    }

    public static /* synthetic */ StandardRecipe copy$default(StandardRecipe standardRecipe, List list, ItemStack itemStack, int n, Object object) {
        if ((n & 1) != 0) {
            list = standardRecipe.inputs;
        }
        if ((n & 2) != 0) {
            itemStack = standardRecipe.output;
        }
        return standardRecipe.copy(list, itemStack);
    }

    @NotNull
    public String toString() {
        return "StandardRecipe(inputs=" + this.inputs + ", output=" + this.output + ")";
    }

    public int hashCode() {
        int result = ((Object)this.inputs).hashCode();
        result = result * 31 + this.output.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StandardRecipe)) {
            return false;
        }
        StandardRecipe standardRecipe = (StandardRecipe)other;
        if (!Intrinsics.areEqual(this.inputs, standardRecipe.inputs)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.output, (Object)standardRecipe.output);
    }
}

