/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.utils;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import lombok.Generated;
import net.guizhanss.fastmachines.libs.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemUtils {
    @ParametersAreNullableByDefault
    public static boolean isSimilar(ItemStack aItem, ItemStack bItem) {
        if (aItem == null || bItem == null) {
            return false;
        }
        if (aItem.getType().isAir() || bItem.getType().isAir()) {
            return false;
        }
        if (aItem.getType() != bItem.getType()) {
            return false;
        }
        if (!aItem.hasItemMeta() || !bItem.hasItemMeta()) {
            return aItem.hasItemMeta() == bItem.hasItemMeta();
        }
        boolean checkLore = aItem.getType() == Material.SPAWNER && bItem.getType() == Material.SPAWNER;
        return SlimefunUtils.isItemSimilar((ItemStack)aItem, (ItemStack)bItem, (boolean)checkLore, (boolean)true, (boolean)true);
    }

    public static boolean isSimilar(ItemStack targetItem, Collection<ItemStack> sourceItems) {
        for (ItemStack sourceItem : sourceItems) {
            if (!ItemUtils.isSimilar(targetItem, sourceItem)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack cleanse(ItemStack item) {
        ItemStack clone = item.clone();
        if (!clone.hasItemMeta()) {
            return clone;
        }
        ItemMeta meta = clone.getItemMeta();
        if (meta.hasDisplayName() || meta.hasLore() || meta.hasEnchants() || meta.hasAttributeModifiers() || meta.hasCustomModelData()) {
            return clone;
        }
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            int maxDamage = Short.MAX_VALUE;
            if (MinecraftVersionUtil.isAtLeast(20, 5) && damageable.hasMaxDamage()) {
                maxDamage = damageable.getMaxDamage();
            }
            if (damageable.getDamage() == 0 || damageable.getDamage() == maxDamage) {
                if (MinecraftVersionUtil.isAtLeast(20, 5)) {
                    return new ItemStack(clone.getType(), clone.getAmount());
                }
                damageable.setDamage(0);
            }
            clone.setItemMeta(meta);
        }
        return clone;
    }

    @Generated
    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

