/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.recipes;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.utils.RecipeUtils;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class RandomRecipe
implements IRecipe {
    private final List<ItemStack> outputs;
    private final ItemStack input;

    public RandomRecipe(ItemStack input, ItemStack ... outputs) {
        this(input, Arrays.asList(outputs));
    }

    public RandomRecipe(ItemStack input, List<ItemStack> outputs) {
        this.input = input;
        this.outputs = new ArrayList<ItemStack>(outputs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomRecipe other = (RandomRecipe)o;
        return this.input.equals((Object)other.input) && this.outputs.equals(other.outputs);
    }

    public int hashCode() {
        int result = this.outputs.hashCode();
        result = 31 * result + this.input.hashCode();
        return result;
    }

    public String toString() {
        return "RandomRecipe{input=" + String.valueOf(this.input) + ", outputs=" + String.valueOf(this.outputs) + "}";
    }

    @Override
    public boolean isDisabledInWorld(@Nonnull World world) {
        for (ItemStack output : this.outputs) {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)output);
            if (sfItem != null && sfItem.isDisabledIn(world)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getRawInput() {
        return this.input;
    }

    public void addOutput(ItemStack ... output) {
        this.addOutput(Arrays.asList(output));
    }

    public void addOutput(@Nonnull Collection<ItemStack> output) {
        this.outputs.addAll(output);
    }

    @Override
    @Nonnull
    public Map<ItemStack, Integer> getInput() {
        return RecipeUtils.countItems(this.input);
    }

    @Override
    @Nonnull
    public ItemStack[] getAllOutputs() {
        return this.outputs.toArray(new ItemStack[0]);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(@Nonnull World world) {
        List<ItemStack> filteredOutputs = this.outputs.stream().filter(output -> {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)output);
            return sfItem == null || !sfItem.isDisabledIn(world);
        }).toList();
        int index = ThreadLocalRandom.current().nextInt(filteredOutputs.size());
        return filteredOutputs.get(index);
    }
}

