/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.libs.guizhanlib.common.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

public final class FileUtil {
    @Nonnull
    @ParametersAreNonnullByDefault
    public static List<String> listJarEntries(File jarFile, BiPredicate<String, JarEntry> predicate, BiFunction<String, JarEntry, String> mapper) throws IOException, SecurityException {
        Preconditions.checkArgument((predicate != null ? 1 : 0) != 0, (Object)"predicate should not be null");
        Preconditions.checkArgument((mapper != null ? 1 : 0) != 0, (Object)"mapper should not be null");
        if (jarFile == null || !jarFile.isFile()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (JarInputStream stream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (!predicate.test(entryName, entry)) continue;
                result.add(mapper.apply(entryName, entry));
            }
        }
        return result;
    }

    @Generated
    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

