/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.fastmachines.core.Registry;
import net.guizhanss.fastmachines.core.services.ConfigurationService;
import net.guizhanss.fastmachines.core.services.IntegrationService;
import net.guizhanss.fastmachines.core.services.ListenerService;
import net.guizhanss.fastmachines.core.services.LocalizationService;
import net.guizhanss.fastmachines.libs.bstats.bukkit.Metrics;
import net.guizhanss.fastmachines.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.fastmachines.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import net.guizhanss.fastmachines.setup.Items;
import net.guizhanss.fastmachines.setup.Researches;
import org.bukkit.plugin.Plugin;

public final class FastMachines
extends AbstractAddon {
    public static final String DEFAULT_LANG = "en-US";
    private Registry registry;
    private ConfigurationService configService;
    private LocalizationService localization;
    private IntegrationService integrationService;
    private boolean debugEnabled = false;

    public FastMachines() {
        super("ybw0014", "FastMachines", "master", "auto-update");
    }

    @Nonnull
    public static Registry getRegistry() {
        return FastMachines.inst().registry;
    }

    @Nonnull
    public static ConfigurationService getConfigService() {
        return FastMachines.inst().configService;
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        return FastMachines.inst().localization;
    }

    @Nonnull
    public static IntegrationService getIntegrationService() {
        return FastMachines.inst().integrationService;
    }

    public static void debug(@Nonnull String message, Object ... args) {
        Preconditions.checkNotNull((Object)message, (Object)"message cannot be null");
        if (FastMachines.inst().debugEnabled) {
            FastMachines.inst().getLogger().log(Level.INFO, "[DEBUG] " + message, args);
        }
    }

    @Nonnull
    private static FastMachines inst() {
        return (FastMachines)((Object)FastMachines.getInstance());
    }

    @Override
    protected void load() {
        if (!this.checkSlimefunVersion()) {
            return;
        }
    }

    @Override
    public void enable() {
        FastMachines.log(Level.INFO, "====================", new Object[0]);
        FastMachines.log(Level.INFO, "     FastMachines   ", new Object[0]);
        FastMachines.log(Level.INFO, "     by ybw0014     ", new Object[0]);
        FastMachines.log(Level.INFO, "====================", new Object[0]);
        this.registry = new Registry();
        this.configService = new ConfigurationService(this);
        this.debugEnabled = this.configService.isDebugEnabled();
        FastMachines.log(Level.INFO, "Loading language...", new Object[0]);
        String lang = this.configService.getLang();
        this.localization = new LocalizationService(this, this.getFile());
        try {
            this.localization.addLanguage(lang);
        }
        catch (Exception e) {
            FastMachines.log(Level.SEVERE, "An error has occurred while loading language " + lang, new Object[0]);
        }
        if (!lang.equals(DEFAULT_LANG)) {
            this.localization.addLanguage(DEFAULT_LANG);
        }
        this.localization.setIdPrefix("FM_");
        FastMachines.log(Level.INFO, this.localization.getString("console.loaded-language"), lang);
        FastMachines.log(Level.INFO, this.localization.getString("console.loading-items"), new Object[0]);
        Items.setup(this);
        this.integrationService = new IntegrationService(this);
        if (this.configService.isEnableResearches()) {
            FastMachines.log(Level.INFO, this.localization.getString("console.loading-researches"), new Object[0]);
            Researches.setup();
            Researches.register();
        }
        new ListenerService(this);
        this.setupMetrics();
    }

    @Override
    public void disable() {
    }

    private void setupMetrics() {
        new Metrics(this, 20046);
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                char[] pluginPackage = new char[]{'n', 'e', 't', '.', 'g', 'u', 'i', 'z', 'h', 'a', 'n', 's', 's', '.', 'g', 'u', 'i', 'z', 'h', 'a', 'n', 'l', 'i', 'b', 'p', 'l', 'u', 'g', 'i', 'n'};
                Class<?> clazz = Class.forName(new String(pluginPackage) + ".updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                new GuizhanBuildsUpdater((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()).start();
            }
        }
    }

    private boolean checkSlimefunVersion() {
        String sfVersion = this.getServer().getPluginManager().getPlugin("Slimefun").getDescription().getVersion();
        if (sfVersion.startsWith("DEV - 1104")) {
            for (int i = 0; i < 100; ++i) {
                this.getLogger().severe("You are using a damn ancient version of Slimefun, update Slimefun first!");
                this.getLogger().severe("Download Slimefun from here: https://blob.build/project/Slimefun4/Dev");
                this.getLogger().severe("Also join the Slimefun discord so you can get the announcements for new versions and will not be a primitive any more.");
                this.getLogger().severe("https://discord.gg/slimefun");
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }
}

