/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.recipes;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.utils.RecipeUtils;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class StandardRecipe
implements IRecipe {
    private final ItemStack output;
    private final Map<ItemStack, Integer> input;

    public StandardRecipe(ItemStack output, ItemStack ... input) {
        this.output = output;
        this.input = RecipeUtils.countItems(input);
    }

    public StandardRecipe(ItemStack output, List<ItemStack> input) {
        this(output, input.toArray(new ItemStack[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardRecipe other = (StandardRecipe)o;
        return this.input.equals(other.input) && this.output.equals((Object)other.output);
    }

    public int hashCode() {
        int result = this.output.hashCode();
        result = 31 * result + this.input.hashCode();
        return result;
    }

    public String toString() {
        return "StandardRecipe{output=" + this.output + ", input=" + this.input + "}";
    }

    @Override
    public boolean isDisabledInWorld(@Nonnull World world) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)this.output);
        return sfItem != null && sfItem.isDisabledIn(world);
    }

    @Override
    @Nonnull
    public ItemStack[] getAllOutputs() {
        return new ItemStack[]{this.output};
    }

    @Override
    @Nonnull
    public ItemStack getOutput(@Nonnull World world) {
        return this.output;
    }

    @Override
    @Generated
    public Map<ItemStack, Integer> getInput() {
        return this.input;
    }
}

