/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.items.machines.infinityexpansion;

import io.github.mooy1.infinityexpansion.items.blocks.InfinityWorkbench;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.RawRecipe;
import net.guizhanss.fastmachines.items.machines.generic.AbstractFastMachine;
import net.guizhanss.fastmachines.utils.RecipeUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class FastInfinityWorkbench
extends AbstractFastMachine {
    private static final ItemStack CRAFT_ITEM = FastMachines.getLocalization().getItem("CRAFT", Material.RESPAWN_ANCHOR, new String[0]);
    private final IntRangeSetting energyPerUse = new IntRangeSetting((SlimefunItem)this, "energy-per-use", 0, 10000000, Integer.MAX_VALUE);
    private final IntRangeSetting energyCapacity = new IntRangeSetting((SlimefunItem)this, "energy-capacity", 0, 100000000, Integer.MAX_VALUE);

    public FastInfinityWorkbench(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(item, recipeType, recipe);
        this.addItemSetting(new ItemSetting[]{this.energyPerUse, this.energyCapacity});
    }

    @Override
    public void registerRecipes() {
        List<RawRecipe> rawRecipes = RecipeUtils.getInfinityMachineRecipes(InfinityWorkbench.class);
        RecipeUtils.registerRecipes(this.recipes, rawRecipes, false);
    }

    @Override
    protected ItemStack getCraftItem() {
        return CRAFT_ITEM;
    }

    @Override
    public int getEnergyPerUse() {
        return FastMachines.getConfigService().isFastMachinesUseEnergy() ? (Integer)this.energyPerUse.getValue() : 0;
    }

    public int getCapacity() {
        return FastMachines.getConfigService().isFastMachinesUseEnergy() ? (Integer)this.energyCapacity.getValue() : 0;
    }
}

