/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.listeners.TranslationsLoadListener;
import net.guizhanss.fastmachines.setup.Items;
import net.guizhanss.fastmachines.setup.Researches;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfiguration;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationDefaults;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationFields;
import net.guizhanss.slimefuntranslation.core.factories.MessageFactory;
import net.guizhanss.slimefuntranslation.utils.FileUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class IntegrationService {
    private final FastMachines plugin;
    private final boolean slimefunTranslationEnabled;

    public IntegrationService(FastMachines plugin) {
        this.plugin = plugin;
        if (this.isEnabled("InfinityExpansion")) {
            Items.setupIE(plugin);
            Researches.setupIE();
        }
        if (this.isEnabled("SlimeFrame")) {
            Items.setupSFrame(plugin);
            Researches.setupSFrame();
        }
        this.slimefunTranslationEnabled = this.isEnabled("SlimefunTranslation");
        if (this.slimefunTranslationEnabled) {
            new TranslationsLoadListener(plugin);
        }
    }

    private boolean isEnabled(String pluginName) {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public void loadTranslations() {
        TranslationConfigurationFields fields = TranslationConfigurationFields.builder().items("items").build();
        TranslationConfigurationDefaults defaults = TranslationConfigurationDefaults.builder().name("FastMachines").prefix("FM_").build();
        List languages = FileUtils.listYamlFiles((File)new File(this.plugin.getDataFolder(), "lang"));
        for (String langFile : languages) {
            File file = new File(this.plugin.getDataFolder(), "lang" + File.separator + langFile);
            String lang = langFile.replace(".yml", "");
            YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)file);
            Optional cfg = TranslationConfiguration.fromFileConfiguration((String)lang, (FileConfiguration)fileConfig, (TranslationConfigurationFields)fields, (TranslationConfigurationDefaults)defaults);
            cfg.ifPresent(translationConfiguration -> translationConfiguration.register((SlimefunAddon)this.plugin));
        }
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String messageKey, Object ... args) {
        MessageFactory.get((Plugin)this.plugin).sendMessage(sender, messageKey, args);
    }

    @Generated
    public boolean isSlimefunTranslationEnabled() {
        return this.slimefunTranslationEnabled;
    }
}

