/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.fastmachines.libs.guizhanlib.minecraft.utils.InventoryUtil;
import net.guizhanss.fastmachines.utils.RecipeUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class MachineUtils {
    @Nonnull
    @ParametersAreNonnullByDefault
    public static Map<ItemStack, Integer> getMachineInputAmount(BlockMenu menu, int[] slots) {
        return RecipeUtils.calculateItems(MachineUtils.getItems(menu, slots));
    }

    @ParametersAreNonnullByDefault
    public static int checksum(Map<ItemStack, Integer> map) {
        int checksum = 0;
        for (Map.Entry<ItemStack, Integer> entry : map.entrySet()) {
            checksum ^= entry.getKey().hashCode() * entry.getValue();
        }
        return checksum;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack[] getItems(BlockMenu menu, int[] slots) {
        ItemStack[] items = new ItemStack[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            items[i] = menu.getItemInSlot(slots[i]);
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)items[i]);
            if (sfItem == null || !SlimefunUtils.isItemSimilar((ItemStack)items[i], (ItemStack)sfItem.getItem(), (boolean)false, (boolean)false, (boolean)true)) continue;
            items[i] = new SlimefunItemStack((SlimefunItemStack)sfItem.getItem(), items[i].getAmount());
        }
        return items;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Pair<List<Integer>, Integer> getItemAmount(BlockMenu menu, int[] slots, ItemStack item) {
        int amount = 0;
        ArrayList<Integer> slotList = new ArrayList<Integer>();
        for (int slot : slots) {
            ItemStack slotItem = menu.getItemInSlot(slot);
            if (slotItem == null || slotItem.getType().isAir() || !SlimefunUtils.isItemSimilar((ItemStack)slotItem, (ItemStack)item, (boolean)false, (boolean)false, (boolean)true)) continue;
            amount += slotItem.getAmount();
            slotList.add(slot);
        }
        return new Pair(slotList, (Object)amount);
    }

    public static boolean removeItems(BlockMenu menu, int[] slots, ItemStack item, int amount) {
        for (int slot : slots) {
            ItemStack slotItem = menu.getItemInSlot(slot);
            if (slotItem == null || slotItem.getType().isAir() || !SlimefunUtils.isItemSimilar((ItemStack)slotItem, (ItemStack)item, (boolean)false, (boolean)false, (boolean)true)) continue;
            if (slotItem.getAmount() > amount) {
                slotItem.setAmount(slotItem.getAmount() - amount);
                return true;
            }
            if (slotItem.getAmount() == amount) {
                menu.replaceExistingItem(slot, null);
                return true;
            }
            amount -= slotItem.getAmount();
            menu.replaceExistingItem(slot, null);
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static int addItem(BlockMenu menu, int[] slots, ItemStack item, int amount) {
        int requiredAmount = item.getAmount() * amount;
        for (int slot : slots) {
            int itemAmount;
            if (requiredAmount <= 0) break;
            ItemStack slotItem = menu.getItemInSlot(slot);
            ItemStack itemCopy = item.clone();
            if (slotItem == null || slotItem.getType().isAir()) {
                itemAmount = Math.min(requiredAmount, item.getMaxStackSize());
                itemCopy.setAmount(itemAmount);
                menu.replaceExistingItem(slot, itemCopy);
                requiredAmount -= itemAmount;
                continue;
            }
            if (!SlimefunUtils.isItemSimilar((ItemStack)slotItem, (ItemStack)item, (boolean)false, (boolean)false, (boolean)true)) continue;
            itemAmount = Math.min(requiredAmount, item.getMaxStackSize() - slotItem.getAmount());
            slotItem.setAmount(slotItem.getAmount() + itemAmount);
            requiredAmount -= itemAmount;
        }
        return requiredAmount;
    }

    @ParametersAreNonnullByDefault
    public static boolean addItem(Player p, BlockMenu menu, int[] slots, ItemStack item, int amount) {
        int remaining = MachineUtils.addItem(menu, slots, item, amount);
        if (remaining > 0) {
            int stacks = remaining / item.getMaxStackSize();
            int reminder = remaining % item.getMaxStackSize();
            ItemStack[] items = new ItemStack[stacks + (reminder > 0 ? 1 : 0)];
            for (int i = 0; i < stacks; ++i) {
                items[i] = item.clone();
                items[i].setAmount(item.getMaxStackSize());
            }
            if (reminder > 0) {
                items[stacks] = item.clone();
                items[stacks].setAmount(reminder);
            }
            InventoryUtil.push(p, items);
            return true;
        }
        return false;
    }

    @Generated
    private MachineUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

