/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.items.machines.generic;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.core.recipes.RandomRecipe;
import net.guizhanss.fastmachines.items.machines.generic.AbstractFastMachine;
import net.guizhanss.fastmachines.utils.ItemUtils;
import net.guizhanss.fastmachines.utils.Keys;
import net.guizhanss.fastmachines.utils.MachineUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public final class FastMachineCache {
    private final AbstractFastMachine machine;
    private final BlockMenu menu;
    private final BlockPosition blockPosition;
    private int inputChecksum;
    private Map<IRecipe, Integer> outputs;
    private int page = -1;
    private ItemStack choice;
    private boolean crafting = false;

    @ParametersAreNonnullByDefault
    public FastMachineCache(AbstractFastMachine machine, BlockMenu menu) {
        this.machine = machine;
        this.menu = menu;
        this.blockPosition = new BlockPosition(menu.getLocation());
        this.init();
    }

    private void init() {
        this.menu.addMenuClickHandler(42, (player, i, itemStack, clickAction) -> {
            --this.page;
            return false;
        });
        this.menu.addMenuClickHandler(51, (player, i, itemStack, clickAction) -> {
            ++this.page;
            return false;
        });
        this.menu.addMenuClickHandler(53, (player, i, itemStack, clickAction) -> {
            int amount = clickAction.isShiftClicked() ? (clickAction.isRightClicked() ? Integer.MAX_VALUE : 64) : (clickAction.isRightClicked() ? 16 : 1);
            if (this.crafting) {
                return false;
            }
            this.crafting = true;
            this.craft(player, amount);
            this.crafting = false;
            return false;
        });
    }

    public void tick() {
        if (FastMachines.getSlimefunTickCount() % 2 == 0) {
            this.findAvailableOutputs();
        }
        if (this.outputs != null) {
            this.updateMenu();
        }
    }

    private void findAvailableOutputs() {
        Map<ItemStack, Integer> machineInputs = MachineUtils.getMachineInputAmount(this.menu, AbstractFastMachine.INPUT_SLOTS);
        if (machineInputs.isEmpty()) {
            return;
        }
        int currentInputChecksum = MachineUtils.checksum(machineInputs);
        if (currentInputChecksum == this.inputChecksum) {
            return;
        }
        this.inputChecksum = currentInputChecksum;
        LinkedHashMap<IRecipe, Integer> newOutputs = new LinkedHashMap<IRecipe, Integer>();
        FastMachines.debug("current machine: {0}, location: {1}", ((Object)((Object)this.machine)).getClass().getSimpleName(), this.blockPosition);
        FastMachines.debug("machine inputs: {0}", machineInputs);
        for (IRecipe recipe : this.machine.getRecipes()) {
            if (recipe.isDisabledInWorld(this.blockPosition.getWorld())) continue;
            FastMachines.debug("checking recipe: {0}", recipe);
            int outputAmount = Integer.MAX_VALUE;
            for (Map.Entry<ItemStack, Integer> recipeInputEntry : recipe.getInput().entrySet()) {
                if (!machineInputs.containsKey(recipeInputEntry.getKey())) {
                    outputAmount = 0;
                    break;
                }
                FastMachines.debug("input: {0}, machine amount: {1}", recipeInputEntry.getKey(), machineInputs.get(recipeInputEntry.getKey()));
                FastMachines.debug("recipe amount: {0}", recipeInputEntry.getValue());
                int inputAmount = machineInputs.get(recipeInputEntry.getKey());
                int recipeAmount = recipeInputEntry.getValue();
                outputAmount = Math.min(outputAmount, inputAmount / recipeAmount);
                FastMachines.debug("result amount: {0}", inputAmount / recipeAmount);
            }
            if (outputAmount <= 0) continue;
            FastMachines.debug("recipe is available, output amount: {0}", outputAmount);
            newOutputs.put(recipe, outputAmount);
        }
        FastMachines.debug("outputs: " + newOutputs, new Object[0]);
        this.outputs = newOutputs;
    }

    private void updateMenu() {
        ItemStack[] outputItems = (ItemStack[])new LinkedHashMap<IRecipe, Integer>(this.outputs).keySet().stream().map(recipe -> recipe.getOutput(this.blockPosition.getWorld())).toArray(ItemStack[]::new);
        int totalPages = (int)Math.ceil((double)this.outputs.size() * 1.0 / (double)AbstractFastMachine.ITEMS_PER_PAGE);
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > totalPages) {
            this.page = totalPages;
        }
        for (int i = 0; i < AbstractFastMachine.ITEMS_PER_PAGE; ++i) {
            int index = (this.page - 1) * AbstractFastMachine.ITEMS_PER_PAGE + i;
            if (totalPages == 0 || index >= this.outputs.size()) {
                this.menu.replaceExistingItem(AbstractFastMachine.PREVIEW_SLOTS[i], ChestMenuUtils.getBackground());
                this.menu.addMenuClickHandler(AbstractFastMachine.PREVIEW_SLOTS[i], ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            ItemStack output = this.getDisplayItem(outputItems[index]);
            this.menu.replaceExistingItem(AbstractFastMachine.PREVIEW_SLOTS[i], output);
            this.menu.addMenuClickHandler(AbstractFastMachine.PREVIEW_SLOTS[i], (player, slot, itemStack, clickAction) -> {
                this.choice = outputItems[index];
                this.updateChoice();
                return false;
            });
        }
        this.updateChoice();
    }

    private void updateChoice() {
        Set<IRecipe> outputItemSet = new LinkedHashMap<IRecipe, Integer>(this.outputs).keySet();
        for (IRecipe recipe : outputItemSet) {
            IRecipe iRecipe = recipe;
            if (iRecipe instanceof RandomRecipe) {
                RandomRecipe randomRecipe = (RandomRecipe)iRecipe;
                if (!ItemUtils.isSimilar(this.choice, List.of(randomRecipe.getAllOutputs()))) continue;
                this.menu.replaceExistingItem(52, this.getDisplayItem(randomRecipe.getOutput(this.blockPosition.getWorld())));
                return;
            }
            ItemStack output = recipe.getOutput(this.blockPosition.getWorld());
            if (!ItemUtils.isSimilar(this.choice, output)) continue;
            this.menu.replaceExistingItem(52, this.getDisplayItem(output));
            return;
        }
        this.menu.replaceExistingItem(52, AbstractFastMachine.NO_ITEM);
    }

    @ParametersAreNonnullByDefault
    private void craft(Player p, int amount) {
        this.craft(p, amount, 0);
    }

    @ParametersAreNonnullByDefault
    private void craft(Player p, int amount, int tries) {
        List outputRecipes;
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"amount must greater than 0");
        try {
            outputRecipes = new LinkedHashMap<IRecipe, Integer>(this.outputs).entrySet().stream().toList();
        }
        catch (Exception e) {
            if (tries < 5) {
                FastMachines.getScheduler().run(() -> this.craft(p, amount, tries + 1));
            }
            return;
        }
        if (this.choice == null) {
            return;
        }
        Optional<Map.Entry> recipeEntry = outputRecipes.stream().filter(entry -> ItemUtils.isSimilar(this.choice, List.of(((IRecipe)entry.getKey()).getAllOutputs()))).findFirst();
        if (recipeEntry.isEmpty()) {
            return;
        }
        Map.Entry recipe = recipeEntry.get();
        int maxAmount = (Integer)recipe.getValue();
        int actualAmount = Math.min(maxAmount, amount);
        if (FastMachines.getAddonConfig().getBoolean("fast-machines.use-energy")) {
            int energyNeeded = this.machine.getEnergyPerUse() * actualAmount;
            int currentEnergy = this.machine.getCharge(this.blockPosition.toLocation());
            if (currentEnergy < energyNeeded) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-energy", new Object[0]);
                return;
            }
            this.machine.setCharge(this.blockPosition.toLocation(), currentEnergy - energyNeeded);
        }
        for (Map.Entry<ItemStack, Integer> inputEntry : ((IRecipe)recipe.getKey()).getInput().entrySet()) {
            int requiredAmount = inputEntry.getValue() * actualAmount;
            Pair<List<Integer>, Integer> itemAmount = MachineUtils.getItemAmount(this.menu, AbstractFastMachine.INPUT_SLOTS, inputEntry.getKey());
            if ((Integer)itemAmount.getSecondValue() < requiredAmount) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-materials", new Object[0]);
                return;
            }
            MachineUtils.removeItems(this.menu, ((List)itemAmount.getFirstValue()).stream().mapToInt(Integer::intValue).toArray(), inputEntry.getKey(), requiredAmount);
        }
        Object inputEntry = recipe.getKey();
        if (inputEntry instanceof RandomRecipe) {
            RandomRecipe randomRecipe = (RandomRecipe)inputEntry;
            boolean machineFull = false;
            for (int i = 0; i < actualAmount; ++i) {
                ItemStack product = randomRecipe.getOutput(this.blockPosition.getWorld()).clone();
                if (!MachineUtils.addItem(p, this.menu, AbstractFastMachine.OUTPUT_SLOTS, product, 1)) continue;
                machineFull = true;
            }
            if (machineFull) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-space", new Object[0]);
            }
        } else {
            ItemStack product = ((IRecipe)recipe.getKey()).getOutput(this.blockPosition.getWorld()).clone();
            if (MachineUtils.addItem(p, this.menu, AbstractFastMachine.OUTPUT_SLOTS, product, actualAmount)) {
                FastMachines.getLocalization().sendMessage((CommandSender)p, "not-enough-space", new Object[0]);
            }
        }
    }

    @Nonnull
    private ItemStack getDisplayItem(@Nonnull ItemStack item) {
        ItemStack newItem = item.clone();
        ItemMeta meta = newItem.getItemMeta();
        PersistentDataAPI.setBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.get("display"), (boolean)true);
        newItem.setItemMeta(meta);
        return newItem;
    }

    @Nonnull
    private ItemStack getOriginalItem(@Nonnull ItemStack displayItem) {
        ItemStack newItem = displayItem.clone();
        ItemMeta meta = newItem.getItemMeta();
        PersistentDataAPI.remove((PersistentDataHolder)meta, (NamespacedKey)Keys.get("display"));
        newItem.setItemMeta(meta);
        return newItem;
    }
}

