/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.items.machines.generic;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.core.recipes.IRecipe;
import net.guizhanss.fastmachines.items.machines.generic.FastMachineCache;
import net.guizhanss.fastmachines.libs.guizhanlib.slimefun.machines.TickingMenuBlock;
import net.guizhanss.fastmachines.setup.Groups;
import net.guizhanss.fastmachines.utils.Heads;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractFastMachine
extends TickingMenuBlock
implements EnergyNetComponent {
    static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    static final int[] OUTPUT_SLOTS = new int[]{27, 28, 29, 30, 31, 32, 33, 34, 35, 18, 19, 20, 21, 22, 23, 24, 25, 26, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    static final int[] PREVIEW_SLOTS = new int[]{36, 37, 38, 39, 40, 41, 45, 46, 47, 48, 49, 50};
    static final int SCROLL_UP_SLOT = 42;
    static final int SCROLL_DOWN_SLOT = 51;
    static final int CHOICE_SLOT = 52;
    static final int CRAFT_SLOT = 53;
    static final int INFO_SLOT = 43;
    static final int ENERGY_SLOT = 44;
    static final int ITEMS_PER_PAGE = PREVIEW_SLOTS.length;
    static final ItemStack NO_ITEM = FastMachines.getLocalization().getItem("NO_ITEM", Material.BARRIER, new String[0]);
    static final ItemStack SCROLL_UP_ITEM = FastMachines.getLocalization().getItem("SCROLL_UP", Heads.ARROW_UP.getTexture(), new String[0]);
    static final ItemStack SCROLL_DOWN_ITEM = FastMachines.getLocalization().getItem("SCROLL_DOWN", Heads.ARROW_DOWN.getTexture(), new String[0]);
    static final ItemStack INFO_ITEM = FastMachines.getLocalization().getItem("INFO", Heads.INFO.getTexture(), new String[0]);
    protected final List<IRecipe> recipes = new ArrayList<IRecipe>();
    private final Map<BlockPosition, FastMachineCache> caches = new HashMap<BlockPosition, FastMachineCache>();

    @ParametersAreNonnullByDefault
    protected AbstractFastMachine(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)Groups.MACHINES, item, recipeType, recipe);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public abstract int getEnergyPerUse();

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        for (int slot : PREVIEW_SLOTS) {
            preset.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(43, INFO_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(52, NO_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(42, SCROLL_UP_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(51, SCROLL_DOWN_ITEM, ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(53, this.getCraftItem(), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(44, (ItemStack)new CustomItemStack(HeadTexture.ENERGY_CONNECTOR.getAsItemStack(), " ", new String[]{LoreBuilder.power((int)this.getEnergyPerUse(), (String)FastMachines.getLocalization().getString("lores.per-craft"))}), ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onNewInstance(BlockMenu menu, Block block) {
        BlockPosition pos = new BlockPosition(block);
        this.caches.put(pos, new FastMachineCache(this, menu));
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void tick(Block b, BlockMenu menu) {
        BlockPosition pos = new BlockPosition(b);
        if (menu.hasViewer() && this.caches.containsKey(pos)) {
            this.caches.get(pos).tick();
        }
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    public void register(@Nonnull SlimefunAddon addon) {
        super.register(addon);
        if (!this.isDisabled()) {
            FastMachines.getRegistry().getAllEnabledFastMachines().add(this);
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        Location l = menu.getLocation();
        menu.dropItems(l, INPUT_SLOTS);
        this.caches.remove(new BlockPosition(l));
    }

    public abstract void registerRecipes();

    protected abstract ItemStack getCraftItem();

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }
}

