/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.core.services;

import com.google.common.base.Preconditions;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.fastmachines.FastMachines;
import net.guizhanss.fastmachines.libs.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.fastmachines.libs.guizhanlib.slimefun.addon.SlimefunLocalization;
import net.guizhanss.fastmachines.utils.FileUtils;
import org.bukkit.command.CommandSender;

public final class LocalizationService
extends SlimefunLocalization {
    private static final String FOLDER_NAME = "lang";
    private final FastMachines plugin;
    private final File jarFile;

    @ParametersAreNonnullByDefault
    public LocalizationService(FastMachines plugin, File jarFile) {
        super(plugin);
        this.plugin = plugin;
        this.jarFile = jarFile;
        this.extractTranslations();
    }

    private void extractTranslations() {
        File translationsFolder = new File(this.plugin.getDataFolder(), FOLDER_NAME);
        if (!translationsFolder.exists()) {
            translationsFolder.mkdirs();
        }
        List<String> translationFiles = FileUtils.listYmlFilesInJar(this.jarFile, FOLDER_NAME);
        for (String translationFile : translationFiles) {
            String filePath = FOLDER_NAME + File.separator + translationFile;
            this.plugin.saveResource(filePath, true);
        }
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String messageKey, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        if (FastMachines.getIntegrationService().isSlimefunTranslationEnabled()) {
            FastMachines.getIntegrationService().sendMessage(sender, messageKey, args);
        } else {
            ChatUtil.send(sender, MessageFormat.format(this.getString("messages." + messageKey), args), new Object[0]);
        }
    }
}

