/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.utils;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemUtils {
    @ParametersAreNullableByDefault
    public static boolean isSimilar(ItemStack aItem, ItemStack bItem) {
        if (aItem == null || bItem == null) {
            return false;
        }
        if (aItem.getType().isAir() || bItem.getType().isAir()) {
            return false;
        }
        if (aItem.getType() != bItem.getType()) {
            return false;
        }
        if (!aItem.hasItemMeta() || !bItem.hasItemMeta()) {
            return aItem.hasItemMeta() == bItem.hasItemMeta();
        }
        boolean checkLore = aItem.getType() == Material.SPAWNER && bItem.getType() == Material.SPAWNER;
        return SlimefunUtils.isItemSimilar((ItemStack)aItem, (ItemStack)bItem, (boolean)checkLore, (boolean)true, (boolean)true);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack removeDamage(ItemStack item) {
        ItemStack clone = item.clone();
        ItemMeta meta = clone.getItemMeta();
        ItemMeta itemMeta = meta;
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage(0);
            clone.setItemMeta(meta);
        }
        return clone;
    }

    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

