/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.fastmachines.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.fastmachines.libs.guizhanlib.utils.FileUtil;

public final class FileUtils {
    @Nonnull
    @ParametersAreNonnullByDefault
    public static List<String> listYmlFilesInJar(File jarFile, String folderName) {
        Preconditions.checkArgument((jarFile != null ? 1 : 0) != 0, (Object)"Jar file cannot be null");
        Preconditions.checkArgument((folderName != null ? 1 : 0) != 0, (Object)"Folder name cannot be null");
        try {
            return FileUtil.listJarEntries(jarFile, (entryName, entry) -> entryName.startsWith(folderName + "/") && !entry.isDirectory() && entryName.endsWith(".yml"), (entryName, entry) -> entryName.replace(folderName + "/", ""));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

