/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.powergenerators.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.config.ConfigManager;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class CustomPowerGen
extends SlimefunItem
implements HologramOwner,
EnergyNetProvider {
    private final Map<Location, Boolean> HOLO_CACHE = new HashMap<Location, Boolean>();
    private final ConfigManager configManager = FNAmplifications.getConfigManager();

    public CustomPowerGen(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int dayRate, int nightRate, int storage) {
        super(itemGroup, item, recipeType, recipe);
        this.setConfigValues(dayRate, nightRate, storage);
        this.setLore((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", (Object)this));
        this.addItemHandler(new ItemHandler[]{this.toggleHologram(), new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                if (BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"holo_status").startsWith("true")) {
                    CustomPowerGen.this.removeHologram(e.getBlock());
                }
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo((Block)e.getBlock(), (String)"holo_status", (String)"true");
                CustomPowerGen.this.HOLO_CACHE.put(e.getBlock().getLocation(), true);
            }
        }});
    }

    public void setLore(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        lore.add(Utils.colorTranslator(LoreBuilder.powerBuffer((int)this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".storage"))));
        lore.add(Utils.colorTranslator("&8\u21e8 &e\u26a1 &7" + Utils.powerFormat.format(this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".dayrate")) + " J/t (Day Rate)"));
        lore.add(Utils.colorTranslator("&8\u21e8 &e\u26a1 &7" + Utils.powerFormat.format(this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".nightrate")) + " J/t (Night Rate)"));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public void setConfigValues(int dayRate, int nightRate, int storage) {
        try {
            this.configManager.initializeConfig(this.getId(), "dayrate", dayRate, "power-xpansion-settings");
            this.configManager.initializeConfig(this.getId(), "nightrate", nightRate, "power-xpansion-settings");
            this.configManager.initializeConfig(this.getId(), "storage", storage, "power-xpansion-settings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public Vector getHologramOffset(@Nonnull Block b) {
        return new Vector(0.5, 0.7, 0.5);
    }

    public BlockUseHandler toggleHologram() {
        return e -> {
            if (!e.getClickedBlock().isPresent()) {
                return;
            }
            Block block = (Block)e.getClickedBlock().get();
            String holoStatus = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"holo_status");
            if (holoStatus == null) {
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"true");
                this.HOLO_CACHE.put(block.getLocation(), true);
                return;
            }
            if (this.HOLO_CACHE.get(block.getLocation()).booleanValue()) {
                this.HOLO_CACHE.put(block.getLocation(), false);
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"false");
                this.removeHologram(block);
            } else {
                this.HOLO_CACHE.put(block.getLocation(), true);
                BlockStorage.addBlockInfo((Location)block.getLocation(), (String)"holo_status", (String)"true");
            }
        };
    }

    public int getGeneratedOutput(@Nonnull Location location, @Nonnull Config data) {
        int generatedOutput;
        int stored = this.getCharge(location);
        int n = generatedOutput = stored < this.getCapacity() ? this.getGeneratingAmount(location.getBlock(), location.getWorld()) : 0;
        if (!this.HOLO_CACHE.containsKey(location)) {
            if (BlockStorage.getLocationInfo((Location)location, (String)"holo_status") != null) {
                this.HOLO_CACHE.put(location, Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)location, (String)"holo_status")));
            } else {
                BlockStorage.addBlockInfo((Location)location, (String)"holo_status", (String)"true");
                this.HOLO_CACHE.put(location, true);
            }
        } else if (this.HOLO_CACHE.get(location).booleanValue()) {
            String charge = this.getCharge(location) <= 0 ? Utils.colorTranslator("&8" + this.getCharge(location)) : Utils.colorTranslator("&a" + this.getCharge(location));
            this.updateHologram(location.getBlock(), Utils.colorTranslator("&eOutput: &a" + generatedOutput + " J/t &8| &eCharge: &a" + charge));
        }
        return generatedOutput;
    }

    public boolean willExplode(@Nonnull Location l, @Nonnull Config data) {
        return false;
    }

    private int getGeneratingAmount(@Nonnull Block location, @Nonnull World world) {
        if (world.getEnvironment() == World.Environment.THE_END || world.getEnvironment() == World.Environment.NETHER) {
            return this.getNightRate();
        }
        if (world.isThundering() || world.hasStorm() || world.getTime() >= 13000L || location.getLocation().add(0.0, 1.0, 0.0).getBlock().getLightFromSky() != 15) {
            return this.getNightRate();
        }
        return this.getDayRate();
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    public int getCapacity() {
        return this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".storage");
    }

    public int getDayRate() {
        return this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".dayrate");
    }

    public int getNightRate() {
        return this.configManager.getCustomConfig("power-xpansion-settings").getInt(this.getId() + ".nightrate");
    }
}

