/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.UUID;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.config.ConfigManager;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.gems.implementation.GemKeysEnum;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractGem
extends SlimefunItem {
    private int chance;
    private final ConfigManager configManager = FNAmplifications.getConfigManager();

    public AbstractGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, 0);
    }

    public AbstractGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int defaultChance) {
        super(itemGroup, item, recipeType, recipe);
        this.initializeSettings(defaultChance);
        GemKeysEnum.GEM_KEYS.getGemKeyList().add(Keys.createKey(this.getId().toLowerCase()));
    }

    public void initializeSettings(int defaultChance) {
        if (defaultChance != 0) {
            this.setConfigChanceValues(defaultChance);
            this.setConfigWorldSettings();
            Utils.setGemTierLore((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", (Object)this), this.getId(), "chance", "%", "&e", "%", 4, "gem-settings");
            this.chance = this.configManager.getCustomConfig("gem-settings").getInt(this.getId() + ".chance");
        } else {
            this.setConfigWorldSettings();
        }
    }

    public void setConfigChanceValues(int chance) {
        try {
            this.configManager.initializeConfig(this.getId(), "chance", chance, "gem-settings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfigWorldSettings() {
        try {
            for (World world : Bukkit.getWorlds()) {
                this.configManager.initializeConfig(this.getId() + ".world-settings", world.getName() + "_enable", true, "gem-settings");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEnabledInCurrentWorld(String worldName) {
        return this.configManager.getCustomConfig("gem-settings").getBoolean(this.getId() + ".world-settings." + worldName + "_enable");
    }

    public void sendGemMessage(Player player, String gemName) {
        Utils.sendMessage(gemName + " has taken effect!", (LivingEntity)player);
    }

    public boolean hasPermissionToThrow(Player player) {
        return Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.INTERACT_BLOCK);
    }

    public void bindGem(SlimefunItem slimefunGemItem, ItemStack itemStackToSocket, Player player) {
        new Gem(slimefunGemItem, itemStackToSocket, player).startSocket();
    }

    public abstract void onDrag(Player var1, SlimefunItem var2, ItemStack var3, ItemStack var4);

    public int getChance() {
        return this.chance;
    }
}

