/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs.implementations;

import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AreaOfEffectStaffTask {
    private final Player player;
    private final Block targetBlock;
    private final String cloudName;
    private final float radius;
    private final int durationInTicks;
    private final Particle particle;
    private final NamespacedKey storageKey;

    public AreaOfEffectStaffTask(Player player, Block targetBlock, String cloudName, float radius, int durationInTicks, Particle particle, @Nullable NamespacedKey key) {
        this.player = player;
        this.targetBlock = targetBlock;
        this.cloudName = cloudName;
        this.radius = radius;
        this.durationInTicks = durationInTicks;
        this.particle = particle;
        this.storageKey = key;
    }

    public void spawnCloud() {
        AreaEffectCloud effectCloud = (AreaEffectCloud)this.getPlayer().getWorld().spawnEntity(this.getTargetBlock().getLocation().add(0.5, 1.0, 0.5), EntityType.AREA_EFFECT_CLOUD);
        effectCloud.setParticle(this.getParticle());
        effectCloud.setDuration(this.getDurationInTicks());
        effectCloud.setRadius(this.getRadius());
        effectCloud.setCustomName(this.getCloudName());
        effectCloud.setCustomNameVisible(false);
        effectCloud.setReapplicationDelay(0);
        if (this.getStorageKey() != null) {
            effectCloud.getPersistentDataContainer().set(this.getStorageKey(), PersistentDataType.STRING, (Object)this.player.getName());
        }
        effectCloud.addCustomEffect(new PotionEffect(PotionEffectType.GLOWING, 0, 0, false, false, false), true);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Block getTargetBlock() {
        return this.targetBlock;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDurationInTicks() {
        return this.durationInTicks;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }
}

