/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class ParryGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    public ParryGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 14);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.HELMET.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.CHESTPLATE.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.LEGGINGS.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.BOOTS.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on armors only", (LivingEntity)player);
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity damager = (LivingEntity)event.getDamager();
        Player player = (Player)event.getEntity();
        if (damager.getEquipment() == null) {
            return;
        }
        if (WeaponArmorEnum.SWORDS.isTagged(damager.getEquipment().getItemInMainHand().getType()) && ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId())) {
            event.setDamage(event.getDamage() * 0.6);
            if (event.getEntity() instanceof Player) {
                this.sendGemMessage(player, this.getItemName());
            }
        }
    }
}

