/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.materialgenerators.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CustomMaterialGenerator
extends SlimefunItem
implements InventoryBlock {
    private final Map<BlockPosition, Integer> generatorProgressMap = new HashMap<BlockPosition, Integer>();
    private final Map<BlockPosition, Integer> generatorConditionMap = new HashMap<BlockPosition, Integer>();
    private final Map<BlockPosition, FastProduceCache> generatorFastProduceMap = new HashMap<BlockPosition, FastProduceCache>();
    private final int sfTickerDelay = Slimefun.getTickerTask().getTickRate();
    private final boolean breakOverTime = FNAmplifications.getInstance().getConfig().getBoolean("Enable-Mat-Gen-Break-Over-Time", true);
    private final boolean dropBrokenVariantOnBreak = FNAmplifications.getInstance().getConfig().getBoolean("Enable-Mat-Gen-Broken-Drop", true);
    private static final ItemStack NOT_GENERATING = CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&cNot Generating", (String[])new String[]{"&ePlace a chest above first!"});
    private static final ItemStack NOT_GENERATING_FULL = CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&cNot Generating", (String[])new String[]{"&eChest inventory full!"});
    private static final ItemStack CONDITION = CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&cCurrent Condition: ", (String[])new String[]{"&ePlace a chest above first!"});
    private static final ItemStack CONDITION_BROKEN = CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&cCurrent Condition: ", (String[])new String[]{"&eGenerator is broken! please repair!", "&eDestroy the block and craft a new one or", "&eUse repair item to add durability"});
    private ItemStack item;
    private String materialName;

    @ParametersAreNonnullByDefault
    public CustomMaterialGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int tickRate) {
        super(itemGroup, item, recipeType, recipe);
        FNAmplifications.getConfigManager().initializeConfig(item.getItemId(), "tickrate", tickRate, "material-gen-tickrate");
        Utils.setLoreByConfigValue((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", (Object)this), this.getId(), "tickrate", "ticks", "&6", " ticks", "material-gen-tickrate");
        this.createPreset(this, this.getInventoryTitle(), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, NOT_GENERATING);
            if (this.breakOverTime) {
                blockMenuPreset.addItem(0, CONDITION);
            }
        });
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                if (CustomMaterialGenerator.this.breakOverTime) {
                    BlockStorage.addBlockInfo((Location)e.getBlock().getLocation(), (String)"generator_status", (String)"100");
                    CustomMaterialGenerator.this.getGeneratorConditionMap().put(new BlockPosition(e.getBlock().getLocation()), 100);
                }
            }
        }, new BlockBreakHandler(false, false){

            public void onPlayerBreak(@Nonnull BlockBreakEvent e, @Nonnull ItemStack item, @Nonnull List<ItemStack> drops) {
                if (CustomMaterialGenerator.this.dropBrokenVariantOnBreak) {
                    e.setDropItems(false);
                    e.setCancelled(true);
                    e.getBlock().setType(Material.AIR);
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), SlimefunItem.getById((String)(BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"id") + "_BROKEN")).getItem());
                }
                CustomMaterialGenerator.this.getGeneratorConditionMap().remove(new BlockPosition(e.getBlock().getLocation()));
                CustomMaterialGenerator.this.getGeneratorProgressMap().remove(new BlockPosition(e.getBlock().getLocation()));
                CustomMaterialGenerator.this.getGeneratorFastProduceMap().remove(new BlockPosition(e.getBlock().getLocation()));
                BlockStorage.clearBlockInfo((Location)e.getBlock().getLocation());
            }
        }});
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            @ParametersAreNonnullByDefault
            public void tick(Block b, SlimefunItem sf, Config data) {
                CustomMaterialGenerator.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    public void tick(@Nonnull Block b) {
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        Block targetBlock = b.getRelative(BlockFace.UP);
        BlockPosition pos = new BlockPosition(b);
        if (this.breakOverTime && this.getGeneratorConditionMap().get(pos) == null) {
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"generator_status") != null) {
                this.getGeneratorConditionMap().put(pos, Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"generator_status")));
            } else {
                BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"generator_status", (String)"100");
                this.getGeneratorConditionMap().put(pos, 100);
            }
        }
        if (this.getGeneratorFastProduceMap().get(pos) == null) {
            FastProduceCache fastProduceCache = new FastProduceCache(0.0, 0, 0);
            if (BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fast_produce_multiplier") != null) {
                fastProduceCache.setMultiplier(Double.parseDouble(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fast_produce_multiplier")));
                fastProduceCache.setCurrentLifetime(Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fast_produce_current_lifetime")));
                fastProduceCache.setMaxLifetime((int)((double)Integer.parseInt(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fast_produce_max_lifetime")) * (20.0 / (double)this.getSfTickerDelay())));
            }
            this.getGeneratorFastProduceMap().put(pos, fastProduceCache);
        }
        if (targetBlock.getType() == Material.CHEST) {
            BlockState state = PaperLib.getBlockState((Block)targetBlock, (boolean)false).getState();
            if (state instanceof InventoryHolder && (!this.breakOverTime || this.getGeneratorConditionMap().get(pos) > 0)) {
                Inventory inv = ((InventoryHolder)state).getInventory();
                if (inv.firstEmpty() != -1) {
                    double fastProduce = this.getGeneratorFastProduceMap().get(pos).getMultiplier() != 0.0 ? this.getGeneratorFastProduceMap().get(pos).getMultiplier() : 1.0;
                    int progress = this.getGeneratorProgressMap().getOrDefault(pos, 0);
                    int generatorCondition = this.getGeneratorConditionMap().getOrDefault(pos, 0);
                    int tickRate = (int)((double)FNAmplifications.getConfigManager().getCustomConfig("material-gen-tickrate").getInt(this.getId() + ".tickrate", 1) / fastProduce);
                    if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                        invMenu.replaceExistingItem(4, CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aGenerating Material", (String[])new String[]{"", "&bMaterial: " + this.materialName, "&bDefault Rate: " + String.valueOf(ChatColor.GREEN) + FNAmplifications.getConfigManager().getCustomConfig("material-gen-tickrate").getInt(this.getId() + ".tickrate") + " &aticks", "", "&2Progress: " + progress + "/" + tickRate, "", this.getGeneratorFastProduceMap().get(pos).getMultiplier() != 0.0 ? "&2Fast Produce Lifetime: " + this.getGeneratorFastProduceMap().get(pos).getCurrentLifetime() + "/" + this.getGeneratorFastProduceMap().get(pos).getMaxLifetime() : "&2Fast Produce: &cInactive"}));
                        if (this.breakOverTime) {
                            this.handleConditionBlockInterface(invMenu, generatorCondition);
                        } else {
                            invMenu.replaceExistingItem(0, ChestMenuUtils.getBackground());
                        }
                    }
                    if (progress >= (tickRate == 0 ? 1 : tickRate)) {
                        progress = 0;
                        if (this.breakOverTime && this.getGeneratorConditionMap().get(pos) != 0 && ThreadLocalRandom.current().nextInt(100) < 25) {
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"generator_status", (String)String.valueOf(generatorCondition - 1));
                            this.getGeneratorConditionMap().put(pos, generatorCondition - 1);
                        }
                        inv.addItem(new ItemStack[]{this.item});
                    } else {
                        ++progress;
                    }
                    if (this.getGeneratorFastProduceMap().get(pos).getMultiplier() != 0.0) {
                        int maxLifeTime;
                        int currentLifeTime = this.getGeneratorFastProduceMap().get(pos).getCurrentLifetime();
                        if (currentLifeTime == (maxLifeTime = this.getGeneratorFastProduceMap().get(pos).getMaxLifetime())) {
                            this.getGeneratorFastProduceMap().get(pos).reset();
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"fast_produce_multiplier", (String)"0");
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"fast_produce_current_lifetime", (String)"0");
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"fast_produce_max_lifetime", (String)"0");
                        } else if (currentLifeTime >= 0) {
                            BlockStorage.addBlockInfo((Location)b.getLocation(), (String)"fast_produce_current_lifetime", (String)String.valueOf(currentLifeTime + 1));
                            this.getGeneratorFastProduceMap().get(pos).setCurrentLifetime(currentLifeTime + 1);
                        }
                    }
                    this.getGeneratorProgressMap().put(pos, progress);
                } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                    invMenu.replaceExistingItem(4, NOT_GENERATING_FULL);
                }
            } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
                invMenu.replaceExistingItem(4, ChestMenuUtils.getBackground());
                if (this.breakOverTime) {
                    invMenu.replaceExistingItem(0, CONDITION_BROKEN);
                }
            }
        } else if (invMenu.toInventory() != null && invMenu.hasViewer()) {
            invMenu.replaceExistingItem(4, NOT_GENERATING);
            invMenu.replaceExistingItem(0, CONDITION);
        }
    }

    public void handleConditionBlockInterface(BlockMenu invMenu, int generatorCondition) {
        if (generatorCondition > 0) {
            if (generatorCondition > 75 && generatorCondition <= 100) {
                invMenu.replaceExistingItem(0, CustomItemStack.create((Material)Material.GREEN_STAINED_GLASS_PANE, (String)"&aCurrent Condition:", (String[])new String[]{"", "&eIn best condition (" + generatorCondition + "%)"}));
            } else if (generatorCondition > 50 && generatorCondition < 75) {
                invMenu.replaceExistingItem(0, CustomItemStack.create((Material)Material.YELLOW_STAINED_GLASS_PANE, (String)"&aCurrent Condition:", (String[])new String[]{"", "&eIn good condition (" + generatorCondition + "%)"}));
            } else if (generatorCondition > 25 && generatorCondition < 50) {
                invMenu.replaceExistingItem(0, CustomItemStack.create((Material)Material.ORANGE_STAINED_GLASS_PANE, (String)"&aCurrent Condition:", (String[])new String[]{"", "&eIn bad condition (" + generatorCondition + "%)"}));
            } else if (generatorCondition < 25) {
                invMenu.replaceExistingItem(0, CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&aCurrent Condition:", (String[])new String[]{"", "&eIn worst condition (" + generatorCondition + "%)"}));
            }
        } else {
            invMenu.replaceExistingItem(0, CustomItemStack.create((Material)Material.RED_STAINED_GLASS_PANE, (String)"&aCurrent Condition:", (String[])new String[]{"", "&eBroken generator (0%)"}));
        }
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    public final CustomMaterialGenerator setItem(@Nonnull Material material) {
        this.item = new ItemStack(material);
        return this;
    }

    public final CustomMaterialGenerator setMaterialName(String materialName) {
        this.materialName = materialName;
        return this;
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public Map<BlockPosition, Integer> getGeneratorProgressMap() {
        return this.generatorProgressMap;
    }

    public Map<BlockPosition, Integer> getGeneratorConditionMap() {
        return this.generatorConditionMap;
    }

    public Map<BlockPosition, FastProduceCache> getGeneratorFastProduceMap() {
        return this.generatorFastProduceMap;
    }

    public int getSfTickerDelay() {
        return this.sfTickerDelay;
    }

    public boolean isBreakOverTime() {
        return this.breakOverTime;
    }

    public boolean isDropBrokenVariantOnBreak() {
        return this.dropBrokenVariantOnBreak;
    }

    public static class FastProduceCache {
        private double multiplier;
        private int currentLifetime;
        private int maxLifetime;

        public FastProduceCache(double multiplier, int currentLifetime, int maxLifetime) {
            this.multiplier = multiplier;
            this.currentLifetime = currentLifetime;
            this.maxLifetime = maxLifetime;
        }

        public void reset() {
            this.multiplier = 0.0;
            this.currentLifetime = 0;
            this.maxLifetime = 0;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public int getCurrentLifetime() {
            return this.currentLifetime;
        }

        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        public void setMultiplier(double multiplier) {
            this.multiplier = multiplier;
        }

        public void setCurrentLifetime(int currentLifetime) {
            this.currentLifetime = currentLifetime;
        }

        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }
    }
}

