/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gears.implementation;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GearTask {
    private final NamespacedKey currentXpValueKey;
    private final NamespacedKey currentArmorLevelKey;
    private final NamespacedKey nextLevelXpKey;
    private final int startingProgress;
    private final int incrementProgress;
    private final int maxLevel;
    private final ItemStack itemStack;
    private final List<UUID> uuidList = new ArrayList<UUID>();

    public GearTask(NamespacedKey currentXpValueKey, NamespacedKey currentArmorLevelKey, NamespacedKey nextLevelXpValueKey, ItemStack item, int startingProgress, int incrementProgress, int maxLevel) {
        this.currentXpValueKey = currentXpValueKey;
        this.currentArmorLevelKey = currentArmorLevelKey;
        this.nextLevelXpKey = nextLevelXpValueKey;
        this.itemStack = item;
        this.startingProgress = startingProgress;
        this.incrementProgress = incrementProgress;
        this.maxLevel = maxLevel;
    }

    public String getProgressBar(int current, int max, int totalBars, char symbol, ChatColor completedColor, ChatColor notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)(String.valueOf(completedColor) + symbol), (int)progressBars) + Strings.repeat((String)(String.valueOf(notCompletedColor) + symbol), (int)(totalBars - progressBars));
    }

    public boolean onHit(EntityDamageByEntityEvent event, Player p, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer progress = meta.getPersistentDataContainer();
        int currentXpValue = (Integer)progress.getOrDefault(this.getCurrentXpValueKey(), PersistentDataType.INTEGER, (Object)0);
        int currentArmorlevel = (Integer)progress.getOrDefault(this.getCurrentArmorLevelKey(), PersistentDataType.INTEGER, (Object)0);
        int nextLevelXpValue = (Integer)progress.getOrDefault(this.getNextLevelXpKey(), PersistentDataType.INTEGER, (Object)this.getStartingProgress());
        int currentXpValueIncremented = currentXpValue + 1;
        if (this.isMaxLevel(currentArmorlevel)) {
            if (!this.uuidList.contains(p.getUniqueId())) {
                Utils.sendMessage(meta.getDisplayName() + " has reached max level!", (LivingEntity)p);
                this.uuidList.add(p.getUniqueId());
            }
            return false;
        }
        progress.set(this.getCurrentXpValueKey(), PersistentDataType.INTEGER, (Object)currentXpValueIncremented);
        List lore = meta.getLore();
        if (currentXpValueIncremented >= 0) {
            this.updateArmour(currentArmorlevel, currentXpValueIncremented, nextLevelXpValue, item, meta, lore);
        }
        if (currentXpValueIncremented == nextLevelXpValue) {
            return this.levelUpArmour(currentArmorlevel, currentXpValueIncremented, nextLevelXpValue, item, meta, progress, lore, p);
        }
        return false;
    }

    public void updateArmour(int armorLevel, int currentXpValueIncremented, int nextLevelXpValue, ItemStack item, ItemMeta meta, List<String> lore) {
        lore.set(7, Utils.colorTranslator("&eLevel: ") + armorLevel);
        lore.set(8, Utils.colorTranslator("&eProgress:"));
        lore.set(9, Utils.colorTranslator("&7[&r" + this.getProgressBar(currentXpValueIncremented, nextLevelXpValue, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + "&7]"));
        if (WeaponArmorEnum.CHESTPLATE.isTagged(this.getItemStack().getType()) && armorLevel == 30 && currentXpValueIncremented == 1) {
            lore.add(10, "");
            lore.add(11, String.valueOf(ChatColor.RED) + "\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec| " + String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + "Effects " + String.valueOf(ChatColor.GOLD) + "|\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec");
            lore.add(12, String.valueOf(ChatColor.GREEN) + "Permanent Saturation");
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public boolean levelUpArmour(int armorLevel, int currentXpValueIncremented, int nextLevelXpValue, ItemStack item, ItemMeta meta, PersistentDataContainer progress, List<String> lore, Player p) {
        if (this.isMaxLevel(armorLevel)) {
            Utils.sendMessage(meta.getDisplayName() + " has reached max level!", (LivingEntity)p);
            return false;
        }
        int currentArmorLevel = armorLevel + 1;
        progress.set(this.getCurrentXpValueKey(), PersistentDataType.INTEGER, (Object)0);
        progress.set(this.getCurrentArmorLevelKey(), PersistentDataType.INTEGER, (Object)currentArmorLevel);
        progress.set(this.getNextLevelXpKey(), PersistentDataType.INTEGER, (Object)(nextLevelXpValue + this.getIncrementProgress()));
        lore.set(7, Utils.colorTranslator("&eLevel: ") + currentArmorLevel);
        lore.set(8, Utils.colorTranslator("&eProgress:"));
        lore.set(9, Utils.colorTranslator("&7[&r" + this.getProgressBar(currentXpValueIncremented, nextLevelXpValue, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + "&7]"));
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.sendLevelUpMessage(p);
        return true;
    }

    public boolean isMaxLevel(int armorLevel) {
        return armorLevel >= this.getMaxLevel();
    }

    public void sendLevelUpMessage(Player p) {
        Utils.sendMessage(this.getItemStack().getItemMeta().getDisplayName() + " leveled up!", (LivingEntity)p);
        p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
    }

    public NamespacedKey getCurrentXpValueKey() {
        return this.currentXpValueKey;
    }

    public NamespacedKey getCurrentArmorLevelKey() {
        return this.currentArmorLevelKey;
    }

    public NamespacedKey getNextLevelXpKey() {
        return this.nextLevelXpKey;
    }

    public int getStartingProgress() {
        return this.startingProgress;
    }

    public int getIncrementProgress() {
        return this.incrementProgress;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

