/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.powergenerators.implementation;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.config.ConfigManager;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomSolarGen
extends SlimefunItem
implements EnergyNetProvider {
    private final ConfigManager configManager = FNAmplifications.getConfigManager();

    public CustomSolarGen(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int dayEnergy, int capacity) {
        super(itemGroup, item, recipeType, recipe);
        this.setConfigValues(dayEnergy, capacity);
        this.setLore((ItemStack)Utils.getField(SlimefunItem.class, "itemStackTemplate", (Object)this));
    }

    public void setLore(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        List lore = meta.getLore();
        lore.add(Utils.colorTranslator(LoreBuilder.powerBuffer((int)this.configManager.getCustomConfig("solar-generator-settings").getInt(this.getId() + ".capacity"))));
        lore.add(Utils.colorTranslator(LoreBuilder.powerPerSecond((int)this.configManager.getCustomConfig("solar-generator-settings").getInt(this.getId() + ".dayEnergy"))));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
    }

    public void setConfigValues(int dayEnergy, int capacity) {
        this.configManager.initializeConfig(this.getId(), "dayEnergy", dayEnergy, "solar-generator-settings");
        this.configManager.initializeConfig(this.getId(), "capacity", capacity, "solar-generator-settings");
    }

    public int getDayEnergy() {
        return this.configManager.getCustomConfig("solar-generator-settings").getInt(this.getId() + ".dayEnergy");
    }

    public int getCapacity() {
        return this.configManager.getCustomConfig("solar-generator-settings").getInt(this.getId() + ".capacity");
    }

    public int getNightEnergy() {
        return 0;
    }

    public final boolean isChargeable() {
        return true;
    }

    public int getGeneratedOutput(Location l, Config data) {
        World world = l.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return 0;
        }
        boolean isDaytime = this.isDaytime(world);
        if (!isDaytime && this.getNightEnergy() < 1) {
            return 0;
        }
        if (world.isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4) && l.getBlock().getLightFromSky() >= 15) {
            return isDaytime ? this.getDayEnergy() : this.getNightEnergy();
        }
        return 0;
    }

    private boolean isDaytime(World world) {
        long time = world.getTime();
        return !world.hasStorm() && !world.isThundering() && (time < 12300L || time > 23850L);
    }

    public void preRegister() {
        super.preRegister();
        BlockUseHandler handler = PlayerRightClickEvent::cancel;
        this.addItemHandler(new ItemHandler[]{handler});
    }
}

