/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class ImpostorGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    public ImpostorGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 14);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.HELMET.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on helmets only", (LivingEntity)player);
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)event.getEntity();
        LivingEntity damager = (LivingEntity)event.getDamager();
        if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId()) && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            float yow = damager.getLocation().getYaw();
            float angleDeg = yow < 0.0f ? 180.0f + yow : yow + 180.0f;
            double nX = Math.cos(Math.toRadians(angleDeg + 90.0f));
            double nZ = Math.sin(Math.toRadians(angleDeg + 90.0f));
            Location newDamagerLoc = new Location(damager.getWorld(), damager.getLocation().getX() + nX, damager.getLocation().getY(), damager.getLocation().getZ() + nZ, damager.getLocation().getYaw(), damager.getLocation().getPitch());
            player.teleport(newDamagerLoc.clone());
            this.sendGemMessage(player, this.getItemName());
        }
    }
}

