/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import ne.fnfal113.fnamplifications.staffs.handlers.EntityStaffImpl;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class StaffOfLocomotion
extends AbstractStaff
implements EntityStaffImpl {
    private final Map<PersistentDataContainer, LivingEntity> entityOwnerMap = new HashMap<PersistentDataContainer, LivingEntity>();
    private final Map<UUID, Boolean> stateMap = new HashMap<UUID, Boolean>();
    private final NamespacedKey identifierKey = Keys.createKey("identifier");

    public StaffOfLocomotion(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 10, Keys.createKey("movestaff"));
    }

    @Override
    public void onEntityClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (event.getRightClicked() instanceof Player) {
            Utils.sendMessage("Staff is not allowed to move players!", (LivingEntity)player);
            return;
        }
        if (!(event.getRightClicked() instanceof LivingEntity)) {
            Utils.sendMessage("You right clicked an invalid entity", (LivingEntity)player);
            return;
        }
        LivingEntity entityRightClicked = (LivingEntity)event.getRightClicked();
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.BREAK_BLOCK)) {
            Utils.sendMessage("You don't have permission to cast " + this.getItemName() + " here!", (LivingEntity)player);
            return;
        }
        ItemStack staffItemStack = player.getInventory().getItemInMainHand();
        ItemMeta meta = staffItemStack.getItemMeta();
        PersistentDataContainer staffPdc = meta.getPersistentDataContainer();
        if (!this.getEntityOwnerMap().containsValue(entityRightClicked)) {
            this.getEntityOwnerMap().remove(staffPdc);
            staffPdc.set(this.getIdentifierKey(), PersistentDataType.DOUBLE, (Object)Math.random());
            this.getEntityOwnerMap().put(staffPdc, entityRightClicked);
            Utils.setLoreByPdc(staffItemStack, meta, entityRightClicked.getName(), "Entity stored: ", "&e", "", " entity");
            Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
            this.getStateMap().put(player.getUniqueId(), true);
        } else {
            Utils.sendMessage("This entity has been stored already by others!", (LivingEntity)player);
        }
    }

    @Override
    public void onClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer data = meta.getPersistentDataContainer();
        Block block = player.getTargetBlockExact(100);
        if (this.getStateMap().containsKey(player.getUniqueId()) && this.getStateMap().get(player.getUniqueId()).booleanValue()) {
            this.getStateMap().remove(player.getUniqueId());
            return;
        }
        if (block == null) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), block, Interaction.BREAK_BLOCK)) {
            Utils.sendMessage("You don't have permission to teleport entity there!", (LivingEntity)player);
            return;
        }
        if (this.getEntityOwnerMap().get(data) == null) {
            Utils.sendMessage("You haven't right clicked an entity or Entity ID changed after server restart", (LivingEntity)player);
            return;
        }
        if (this.getEntityOwnerMap().containsKey(data)) {
            LivingEntity entity = this.getEntityOwnerMap().get(data);
            entity.teleport(block.getLocation().add(0.5, 1.0, 0.5));
            this.getEntityOwnerMap().remove(data);
            Utils.setLoreByPdc(item, meta, "none", "Entity stored: ", "&e", "", "");
            this.getStaffTask().updateMeta(item, meta, player);
        }
    }

    public Map<PersistentDataContainer, LivingEntity> getEntityOwnerMap() {
        return this.entityOwnerMap;
    }

    public Map<UUID, Boolean> getStateMap() {
        return this.stateMap;
    }

    public NamespacedKey getIdentifierKey() {
        return this.identifierKey;
    }
}

