/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gears.implementation;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GearTask {
    private final NamespacedKey storageKey;
    private final NamespacedKey storageKey2;
    private final NamespacedKey storageKey3;
    private final int startingProgress;
    private final int incrementProgress;
    private final int maxLevel;
    private final ItemStack itemStack;
    private final List<UUID> uuidList = new ArrayList<UUID>();

    public GearTask(NamespacedKey key1, NamespacedKey key2, NamespacedKey key3, ItemStack item, int startingProgress, int incrementProgress, int maxLevel) {
        this.storageKey = key1;
        this.storageKey2 = key2;
        this.storageKey3 = key3;
        this.itemStack = item;
        this.startingProgress = startingProgress;
        this.incrementProgress = incrementProgress;
        this.maxLevel = maxLevel;
    }

    public String getProgressBar(int current, int max, int totalBars, char symbol, ChatColor completedColor, ChatColor notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)((float)totalBars * percent);
        return Strings.repeat((String)(String.valueOf(completedColor) + symbol), (int)progressBars) + Strings.repeat((String)(String.valueOf(notCompletedColor) + symbol), (int)(totalBars - progressBars));
    }

    public boolean onHit(EntityDamageByEntityEvent event, Player p, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer progress = meta.getPersistentDataContainer();
        int xpAmount = (Integer)progress.getOrDefault(this.getStorageKey(), PersistentDataType.INTEGER, (Object)0);
        int armorLevel = (Integer)progress.getOrDefault(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)0);
        int maxXpReq = (Integer)progress.getOrDefault(this.getStorageKey3(), PersistentDataType.INTEGER, (Object)this.getStartingProgress());
        int xpAmountIncremented = xpAmount + 1;
        if (this.isMaxLevel(armorLevel)) {
            if (!this.uuidList.contains(p.getUniqueId())) {
                Utils.sendMessage(meta.getDisplayName() + " has reached max level!", (LivingEntity)p);
                this.uuidList.add(p.getUniqueId());
            }
            return false;
        }
        progress.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)xpAmountIncremented);
        List lore = meta.getLore();
        if (xpAmountIncremented >= 0) {
            this.updateArmour(armorLevel, xpAmountIncremented, maxXpReq, item, meta, lore);
        }
        if (xpAmountIncremented == maxXpReq) {
            return this.levelUpArmour(armorLevel, xpAmountIncremented, maxXpReq, item, meta, progress, lore, p);
        }
        return false;
    }

    public void updateArmour(int armorLevel, int xpAmountIncremented, int maxXpReq, ItemStack item, ItemMeta meta, List<String> lore) {
        lore.set(7, Utils.colorTranslator("&eLevel: ") + armorLevel);
        lore.set(8, Utils.colorTranslator("&eProgress:"));
        lore.set(9, Utils.colorTranslator("&7[&r" + this.getProgressBar(xpAmountIncremented, maxXpReq, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + "&7]"));
        if (WeaponArmorEnum.CHESTPLATE.isTagged(this.getItemStack().getType()) && armorLevel == 30 && xpAmountIncremented == 1) {
            lore.add(10, "");
            lore.add(11, String.valueOf(ChatColor.RED) + "\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec| " + String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + "Effects " + String.valueOf(ChatColor.GOLD) + "|\u25ec\u25ec\u25ec\u25ec\u25ec\u25ec");
            lore.add(12, String.valueOf(ChatColor.GREEN) + "Permanent Saturation");
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public boolean levelUpArmour(int armorLevel, int xpAmountIncremented, int maxXpReq, ItemStack item, ItemMeta meta, PersistentDataContainer progress, List<String> lore, Player p) {
        if (this.isMaxLevel(armorLevel)) {
            Utils.sendMessage(meta.getDisplayName() + " has reached max level!", (LivingEntity)p);
            return false;
        }
        int currentArmorLevel = armorLevel + 1;
        progress.set(this.getStorageKey(), PersistentDataType.INTEGER, (Object)0);
        progress.set(this.getStorageKey2(), PersistentDataType.INTEGER, (Object)currentArmorLevel);
        progress.set(this.getStorageKey3(), PersistentDataType.INTEGER, (Object)(maxXpReq + this.getIncrementProgress()));
        lore.set(7, Utils.colorTranslator("&eLevel: ") + currentArmorLevel);
        lore.set(8, Utils.colorTranslator("&eProgress:"));
        lore.set(9, Utils.colorTranslator("&7[&r" + this.getProgressBar(xpAmountIncremented, maxXpReq, 10, '\u25a0', ChatColor.YELLOW, ChatColor.GRAY) + "&7]"));
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.sendLevelUpMessage(p);
        return true;
    }

    public boolean isMaxLevel(int armorLevel) {
        return armorLevel >= this.getMaxLevel();
    }

    public void sendLevelUpMessage(Player p) {
        Utils.sendMessage(this.getItemStack().getItemMeta().getDisplayName() + " leveled up!", (LivingEntity)p);
        p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
    }

    public NamespacedKey getStorageKey() {
        return this.storageKey;
    }

    public NamespacedKey getStorageKey2() {
        return this.storageKey2;
    }

    public NamespacedKey getStorageKey3() {
        return this.storageKey3;
    }

    public int getStartingProgress() {
        return this.startingProgress;
    }

    public int getIncrementProgress() {
        return this.incrementProgress;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

