/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import ne.fnfal113.fnamplifications.FNAmplifications;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Map<String, FileConfiguration> fileConfigurationMap = new HashMap<String, FileConfiguration>();

    public <T> void initializeConfig(String itemNameSection, String settings, T val, String fileName) {
        FileConfiguration customConfig = this.getCustomConfig(fileName);
        try {
            if (!customConfig.isConfigurationSection(itemNameSection)) {
                customConfig.createSection(itemNameSection).set(settings, val);
                customConfig.save(new File(FNAmplifications.getInstance().getDataFolder(), fileName + ".yml"));
            } else if (!customConfig.getConfigurationSection(itemNameSection).contains(settings)) {
                customConfig.getConfigurationSection(itemNameSection).set(settings, val);
                customConfig.save(new File(FNAmplifications.getInstance().getDataFolder(), fileName + ".yml"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonObject loadJson(String jsonName) {
        try {
            InputStream resource = FNAmplifications.class.getResourceAsStream("/json/" + jsonName + ".json");
            return new JsonParser().parse((Reader)new InputStreamReader(resource)).getAsJsonObject();
        }
        catch (JsonParseException | NullPointerException e) {
            e.printStackTrace();
            return new JsonObject();
        }
    }

    public FileConfiguration getCustomConfig(String fileName) {
        if (this.getFileConfigurationMap().containsKey(fileName)) {
            return this.getFileConfigurationMap().get(fileName);
        }
        File customConfigFile = new File(FNAmplifications.getInstance().getDataFolder(), fileName + ".yml");
        YamlConfiguration customConfig = new YamlConfiguration();
        try {
            if (!customConfigFile.exists()) {
                customConfigFile.getParentFile().mkdirs();
                FNAmplifications.getInstance().saveResource(fileName + ".yml", false);
            }
            customConfig.load(customConfigFile);
            this.getFileConfigurationMap().put(fileName, (FileConfiguration)customConfig);
            return customConfig;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return customConfig;
        }
    }

    public Map<String, FileConfiguration> getFileConfigurationMap() {
        return this.fileConfigurationMap;
    }
}

