/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.mysteriousitems.implementation;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.utils.Utils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StickTask {
    public final NamespacedKey xpKey;
    public final NamespacedKey damageInflictedKey;
    public final Map<Enchantment, Integer> enchantmentMap;
    public final String weaponLore;
    public final String stickLore;
    public final int effectCount;
    public final int requiredLevel;

    @ParametersAreNonnullByDefault
    public StickTask(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore) {
        this(key1, key2, enchantmentMap, weaponLore, stickLore, 0, 0);
    }

    @ParametersAreNonnullByDefault
    public StickTask(NamespacedKey key1, NamespacedKey key2, Map<Enchantment, Integer> enchantmentMap, String weaponLore, String stickLore, int effectCount, int levelReq) {
        this.xpKey = key1;
        this.damageInflictedKey = key2;
        this.enchantmentMap = enchantmentMap;
        this.weaponLore = weaponLore;
        this.stickLore = stickLore;
        this.effectCount = effectCount;
        this.requiredLevel = levelReq;
    }

    public int getPdc(PersistentDataContainer pdc, NamespacedKey key) {
        return (Integer)pdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    public void onInteract(PlayerInteractEvent event, Material material) {
        if (event.getPlayer().getLevel() < this.getRequiredLevel()) {
            this.darkenVision(event.getPlayer(), this.getRequiredLevel());
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemMeta meta = itemStack.getItemMeta();
        this.convertToWeapon(itemStack, meta, material, player);
    }

    public void convertToWeapon(ItemStack itemStack, ItemMeta meta, Material material, Player player) {
        if (itemStack.getType() == material) {
            return;
        }
        meta.setUnbreakable(true);
        this.getEnchantmentMap().forEach((Key, Value) -> meta.addEnchant(Key, Value.intValue(), true));
        this.itemMetaUpdate(itemStack, meta, this.getWeaponLore(), 0, this.getPdc(meta.getPersistentDataContainer(), this.getXpKey()), false);
        itemStack.setType(material);
        player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_MIRROR_MOVE, 1.0f, 1.0f);
        player.getWorld().playEffect(player.getLocation().add(0.3, 0.4, 0.45), Effect.ENDER_SIGNAL, 1);
        player.getWorld().spawnParticle(Particle.FLASH, player.getLocation().add(0.3, 0.4, 0.45), 2, 0.1, 0.1, 0.1, 0.1);
    }

    public void convertToStick(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore.clear();
        lore.add(this.getStickLore());
        meta.setLore(lore);
        meta.getEnchants().forEach((enchant, value) -> meta.removeEnchant(enchant));
        item.setType(Material.STICK);
        item.setItemMeta(meta);
    }

    public boolean onSwing(ItemStack item, Player player, double damageAmount, int chance, int levelDeduction) {
        if (player.getLevel() >= this.getRequiredLevel()) {
            if (ThreadLocalRandom.current().nextInt(100) > chance) {
                this.itemMetaUpdate(item, item.getItemMeta(), this.getWeaponLore(), (int)damageAmount, levelDeduction, false);
                return false;
            }
            player.setLevel(player.getLevel() - levelDeduction);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Utils.colorTranslator("&d" + levelDeduction + " xp levels has been consumed from you")));
            this.itemMetaUpdate(item, item.getItemMeta(), this.getWeaponLore(), (int)damageAmount, levelDeduction, true);
            return true;
        }
        this.convertToStick(item);
        this.darkenVision(player, this.getRequiredLevel());
        return false;
    }

    public void itemMetaUpdate(ItemStack item, ItemMeta meta, String loreType, int damageInflicted, int xpLevelDeduction, boolean isLevelDeducted) {
        List lore2 = meta.getLore();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int xpAmount = this.getPdc(pdc, this.getXpKey());
        int damageAmount = damageInflicted + this.getPdc(pdc, this.getDamageInflictedKey());
        if (isLevelDeducted) {
            xpAmount += xpLevelDeduction;
        }
        pdc.set(this.getXpKey(), PersistentDataType.INTEGER, (Object)xpAmount);
        pdc.set(this.getDamageInflictedKey(), PersistentDataType.INTEGER, (Object)damageAmount);
        lore2.set(0, loreType);
        try {
            lore2.set(1, String.valueOf(ChatColor.YELLOW) + "Total Exp Levels Consumed: " + String.valueOf(ChatColor.WHITE) + xpAmount);
            lore2.set(2, String.valueOf(ChatColor.YELLOW) + "Total Damage inflicted: " + String.valueOf(ChatColor.WHITE) + damageAmount);
        }
        catch (IndexOutOfBoundsException e) {
            lore2.add(1, String.valueOf(ChatColor.YELLOW) + "Total Exp Levels Consumed: " + String.valueOf(ChatColor.WHITE) + xpAmount);
            lore2.add(2, String.valueOf(ChatColor.YELLOW) + "Total Damage inflicted: " + String.valueOf(ChatColor.WHITE) + damageAmount);
        }
        if (lore2.size() < 4) {
            lore2.add("");
            lore2.add(Utils.colorTranslator("&c\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4| &4&lEffects &f|\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3"));
            lore2.add(String.valueOf(ChatColor.BLUE) + "\u25c6 " + this.getEffectCount() + " Mystery effect/s");
            lore2.add(Utils.colorTranslator("&c\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4\u25e2\u25e4| &4\u25e2\u25e4\u25e4\u25e5\u25e4\u25e5\u25e4\u25e5\u25e4\u25e5\u25e5\u25e3 &f|\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3\u25e5\u25e3"));
        }
        meta.setLore(lore2);
        item.setItemMeta(meta);
    }

    @ParametersAreNonnullByDefault
    public void darkenVision(Player player, int level) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 300, 2, false, false));
        player.sendTitle(String.valueOf(ChatColor.DARK_RED) + "Your vision darkens!", String.valueOf(ChatColor.RED) + "The stick is unpredictable", 40, 120, 40);
        player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[FNAmpli" + String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.BOLD) + "fications] > " + String.valueOf(ChatColor.YELLOW) + "You're too weak, make sure your exp level is higher than " + level);
    }

    public NamespacedKey getXpKey() {
        return this.xpKey;
    }

    public NamespacedKey getDamageInflictedKey() {
        return this.damageInflictedKey;
    }

    public Map<Enchantment, Integer> getEnchantmentMap() {
        return this.enchantmentMap;
    }

    public String getWeaponLore() {
        return this.weaponLore;
    }

    public String getStickLore() {
        return this.stickLore;
    }

    public int getEffectCount() {
        return this.effectCount;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }
}

