/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import ne.fnfal113.fnamplifications.gems.RetaliateGem;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.implementation.GemKeysEnum;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GemUnbinderTask {
    private final Player player;
    private final ItemStack itemInOffhand;

    public GemUnbinderTask(Player player, ItemStack itemInOffhand) {
        this.player = player;
        this.itemInOffhand = itemInOffhand;
    }

    public void showAvailableGemsUI() {
        PersistentDataContainer pdc = this.getItemInOffhand().getItemMeta().getPersistentDataContainer();
        if (pdc.isEmpty()) {
            Utils.sendMessage("Offhand item doesn't have bounded gems!", (LivingEntity)this.getPlayer());
            return;
        }
        ArrayList<ItemStack> gemArray = new ArrayList<ItemStack>();
        for (NamespacedKey key : GemKeysEnum.GEM_KEYS.getGemKeyList()) {
            SlimefunItem gem;
            if (!pdc.has(key, PersistentDataType.STRING) || !((gem = SlimefunItem.getById((String)((String)pdc.get(key, PersistentDataType.STRING)))) instanceof AbstractGem)) continue;
            gemArray.add(gem.getItem().clone());
        }
        if (gemArray.isEmpty()) {
            Utils.sendMessage("Offhand item doesn't have bounded gems!", (LivingEntity)this.getPlayer());
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)9, (String)Utils.colorTranslator("&cSelect a gem to unbind"));
        for (ItemStack gems : gemArray) {
            inventory.addItem(new ItemStack[]{gems});
        }
        this.getPlayer().openInventory(inventory);
        this.getPlayer().playSound(this.player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 1.0f, 1.0f);
    }

    public void unbindGem(SlimefunItem gem, int chance) {
        this.getPlayer().getInventory().getItemInMainHand().setAmount(0);
        if (ThreadLocalRandom.current().nextInt(100) <= chance) {
            ItemMeta meta = this.getItemInOffhand().getItemMeta();
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            NamespacedKey socketAmountKey = Keys.createKey(this.getItemInOffhand().getType().toString().toLowerCase() + "_socket_amount");
            NamespacedKey gemKey = Keys.createKey(gem.getId().toLowerCase());
            List lore = meta.getLore();
            this.removeOtherPdc(pdc, gem);
            pdc.remove(gemKey);
            pdc.set(socketAmountKey, PersistentDataType.INTEGER, (Object)((Integer)pdc.get(socketAmountKey, PersistentDataType.INTEGER) - 1));
            if ((Integer)pdc.get(socketAmountKey, PersistentDataType.INTEGER) == 0) {
                for (int i = 0; i < lore.indexOf(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5")) + 1; ++i) {
                    if (!((String)lore.get(i)).contains(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"))) continue;
                    lore.remove(i - 1);
                }
                Predicate<String> condition = line -> line.contains(Utils.colorTranslator(gem.getItemName())) || line.contains(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5")) || line.contains(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4&c\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
                lore.removeIf(condition);
                pdc.remove(socketAmountKey);
            } else {
                lore.removeIf(line -> line.contains(Utils.colorTranslator(gem.getItemName())));
            }
            meta.setLore(lore);
            this.getItemInOffhand().setItemMeta(meta);
            Utils.sendMessage("Successfully removed selected gem!", (LivingEntity)this.getPlayer());
            this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_VILLAGER_WORK_WEAPONSMITH, 1.0f, 1.0f);
        } else {
            Utils.sendMessage("Failed to unbind the gem from the item!", (LivingEntity)this.getPlayer());
            this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_ZOMBIE_INFECT, 1.0f, 1.0f);
        }
    }

    public void removeOtherPdc(PersistentDataContainer pdc, SlimefunItem gem) {
        NamespacedKey gemTierKey = Keys.createKey(gem.getId().toLowerCase() + "_gem_tier");
        if (pdc.has(gemTierKey, PersistentDataType.INTEGER)) {
            pdc.remove(gemTierKey);
        }
        if (gem instanceof RetaliateGem) {
            pdc.remove(Keys.RETURN_WEAPON_KEY);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemInOffhand() {
        return this.itemInOffhand;
    }
}

