/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.bstats.bukkit.Metrics;
import ne.fnfal113.fnamplifications.config.ConfigManager;
import ne.fnfal113.fnamplifications.dough.updater.BlobBuildUpdater;
import ne.fnfal113.fnamplifications.gears.commands.GearCommands;
import ne.fnfal113.fnamplifications.gears.runnables.ArmorEquipRunnable;
import ne.fnfal113.fnamplifications.integrations.VaultIntegration;
import ne.fnfal113.fnamplifications.items.FNAmpItemSetup;
import ne.fnfal113.fnamplifications.test.ShockwaveTest;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FNAmplifications
extends JavaPlugin
implements SlimefunAddon {
    private static FNAmplifications instance;
    private static VaultIntegration vaultIntegration;
    private final ConfigManager configManager = new ConfigManager();

    public void onEnable() {
        FNAmplifications.setInstance(this);
        new Metrics(this, 13219);
        this.getLogger().info("************************************************************");
        this.getLogger().info("*         FN Amplifications - Created by FN_FAL113         *");
        this.getLogger().info("*             From machines, custom items to PvP           *");
        this.getLogger().info("*               https://discord.gg/SqD3gg5SAU              *");
        this.getLogger().info("************************************************************");
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        FNAmplifications.setVaultIntegration(this);
        FNAmpItemSetup.INSTANCE.init();
        this.registerCommands();
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new ArmorEquipRunnable(), 0L, (long)this.getConfig().getInt("armor-update-period") * 20L);
        if (this.getConfig().getBoolean("auto-update", true) && this.getDescription().getVersion().startsWith("Dev - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "FNAmplifications", "Experimental").start();
        }
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)FNAmplifications.getInstance());
        this.getLogger().log(Level.INFO, "Cancelled any running task that exist");
    }

    public void registerCommands() {
        Objects.requireNonNull(this.getCommand("fngear")).setExecutor((CommandExecutor)new GearCommands());
        this.getCommand("fnshockwavetest").setExecutor((CommandExecutor)new ShockwaveTest());
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/FN-FAL113/FN-FAL-s-Amplifications/issues";
    }

    public ConfigManager getConfigManager() {
        return FNAmplifications.instance.configManager;
    }

    private static void setInstance(FNAmplifications ins) {
        instance = ins;
    }

    public static FNAmplifications getInstance() {
        return instance;
    }

    public static void setVaultIntegration(FNAmplifications ins) {
        vaultIntegration = new VaultIntegration(ins);
    }

    public static VaultIntegration getVaultIntegration() {
        return vaultIntegration;
    }
}

