/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Machines;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import ne.fnfal113.fnamplifications.ConfigValues.ReturnConfValue;
import ne.fnfal113.fnamplifications.ExtraUtils.interfaces.InventoryBlock;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.Items.FNAmpItems;
import ne.fnfal113.fnamplifications.Multiblock.FnAssemblyStation;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.block.data.type.Door;
import org.bukkit.inventory.ItemStack;

public class ElectricBlockBreaker
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    private static final SlimefunAddon plugin = FNAmplifications.getInstance();
    private static final ReturnConfValue value = new ReturnConfValue();
    public static final int CHANGE_MODE = 0;
    public static final int ON_OFF = 8;
    private static final Map<BlockPosition, Integer> breakerProgress = new HashMap<BlockPosition, Integer>();
    protected static final Map<Location, Boolean> mode = new HashMap<Location, Boolean>();
    protected static final Map<Location, Boolean> toggleOnOff = new HashMap<Location, Boolean>();
    private static final ItemStack VERSIONED_AMETHYST = Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17) ? new ItemStack(Material.BUDDING_AMETHYST) : new ItemStack(Material.BEDROCK);
    private static final CustomItemStack notOperating = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&cNot Operating...", new String[]{"&ePlace a block facing the dispenser!"});
    private static final CustomItemStack noPower = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNo Power!", new String[]{"&ePower it up first!"});
    private static final CustomItemStack notRunning = new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&cNot Running", new String[]{"&eToggle it on first"});
    private static final CustomItemStack breakBlockNaturally = new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&d&lMode:", new String[]{"&eBreak block naturally (No Silk Touch)", "Click to change"});
    private static final CustomItemStack dropBlockNaturally = new CustomItemStack(Material.CYAN_STAINED_GLASS_PANE, "&d&lMode:", new String[]{"&eDrop block naturally (Silk Touch)", "Click to change"});
    private static final CustomItemStack toggled_On = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, "&d&lToggle:", new String[]{"&eEnabled (Running)", "Click to change"});
    private static final CustomItemStack toggled_Off = new CustomItemStack(Material.WHITE_STAINED_GLASS_PANE, "&d&lToggle:", new String[]{"&eDisabled (Not Running)", "Click to change"});
    private int energyCapacity = -1;
    private int energyConsumedPerTick = -1;
    private int rate = 2;

    @ParametersAreNonnullByDefault
    public ElectricBlockBreaker(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.createPreset(this, this.getInventoryTitle(), blockMenuPreset -> {
            for (int i = 0; i < 9; ++i) {
                blockMenuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            blockMenuPreset.addItem(4, (ItemStack)noPower);
        });
    }

    public static void setup() {
        new ElectricBlockBreaker((ItemGroup)FNAmpItems.MACHINES, FNAmpItems.FN_BLOCK_BREAKER_1, FnAssemblyStation.RECIPE_TYPE, new ItemStack[]{FNAmpItems.GEAR_PART, FNAmpItems.COMPONENT_PART, FNAmpItems.GEAR_PART, new ItemStack(Material.IRON_PICKAXE), FNAmpItems.BASIC_MACHINE_BLOCK, new ItemStack(Material.IRON_PICKAXE), FNAmpItems.ALUMINUM_PLATING, FNAmpItems.POWER_COMPONENT, FNAmpItems.ALUMINUM_PLATING}).setRate(value.blockBreaker1Ticks()).setCapacity(512).setEnergyConsumption(32).register(plugin);
        new ElectricBlockBreaker((ItemGroup)FNAmpItems.MACHINES, FNAmpItems.FN_BLOCK_BREAKER_2, FnAssemblyStation.RECIPE_TYPE, new ItemStack[]{new SlimefunItemStack(FNAmpItems.GEAR_PART, 2), FNAmpItems.COMPONENT_PART, new SlimefunItemStack(FNAmpItems.GEAR_PART, 2), new ItemStack(Material.DIAMOND_PICKAXE), new SlimefunItemStack(FNAmpItems.BASIC_MACHINE_BLOCK, 2), new ItemStack(Material.DIAMOND_PICKAXE), FNAmpItems.BRASS_PLATING, new SlimefunItemStack(FNAmpItems.POWER_COMPONENT, 2), FNAmpItems.BRASS_PLATING}).setRate(value.blockBreaker2Ticks()).setCapacity(1024).setEnergyConsumption(64).register(plugin);
        new ElectricBlockBreaker((ItemGroup)FNAmpItems.MACHINES, FNAmpItems.FN_BLOCK_BREAKER_3, FnAssemblyStation.RECIPE_TYPE, new ItemStack[]{new SlimefunItemStack(FNAmpItems.GEAR_PART, 3), FNAmpItems.COMPONENT_PART, new SlimefunItemStack(FNAmpItems.GEAR_PART, 3), new ItemStack(Material.NETHERITE_PICKAXE), FNAmpItems.HIGHTECH_MACHINE_BLOCK, new ItemStack(Material.NETHERITE_PICKAXE), FNAmpItems.REINFORCED_CASING, new SlimefunItemStack(FNAmpItems.POWER_COMPONENT, 2), FNAmpItems.REINFORCED_CASING}).setRate(value.blockBreaker3Ticks()).setCapacity(2048).setEnergyConsumption(128).register(plugin);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            @ParametersAreNonnullByDefault
            public void tick(Block b, SlimefunItem sf, Config data) {
                ElectricBlockBreaker.this.tick(b);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    public void tick(@Nonnull Block b) {
        BlockMenu invMenu = BlockStorage.getInventory((Block)b);
        Block targetBlock = b.getRelative(((Dispenser)b.getState().getBlockData()).getFacing());
        World location = targetBlock.getWorld();
        this.onNewInstance(invMenu, b);
        this.onNewInstanceToggle(invMenu, b);
        if (invMenu == null) {
            return;
        }
        invMenu.replaceExistingItem(4, (ItemStack)notRunning);
        if (this.getCharge(b.getLocation()) > 0 && toggleOnOff.get(b.getLocation()).booleanValue()) {
            invMenu.replaceExistingItem(4, (ItemStack)notOperating);
            if (!(targetBlock.getType().equals((Object)Material.AIR) || !targetBlock.getType().isBlock() || !targetBlock.getType().isSolid() || this.isBed(targetBlock) || this.isDoor(targetBlock) || targetBlock.getType().equals((Object)Material.BEDROCK) || targetBlock.getType().equals((Object)Material.END_PORTAL_FRAME) || targetBlock.getType().equals((Object)Material.FROSTED_ICE))) {
                BlockPosition pos = new BlockPosition(b);
                int progress = breakerProgress.getOrDefault(pos, 0);
                if (invMenu.toInventory() != null && !invMenu.toInventory().getViewers().isEmpty()) {
                    invMenu.replaceExistingItem(4, (ItemStack)new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&aOperating!", new String[]{"", "&bRate: " + this.rate + " Block per tick", "&2Breaking block at rate: " + progress + "/" + this.rate}));
                }
                if (progress >= this.rate) {
                    progress = 0;
                    if (mode.containsValue(true)) {
                        if (BlockStorage.hasBlockInfo((Block)targetBlock) || BlockStorage.hasInventory((Block)targetBlock)) {
                            location.dropItemNaturally(targetBlock.getLocation(), BlockStorage.retrieve((Block)targetBlock));
                            targetBlock.setType(Material.AIR);
                        } else {
                            targetBlock.breakNaturally();
                            BlockStorage.clearBlockInfo((Location)targetBlock.getLocation(), (boolean)true);
                        }
                    } else if (BlockStorage.hasBlockInfo((Block)targetBlock) || BlockStorage.hasInventory((Block)targetBlock)) {
                        location.dropItemNaturally(targetBlock.getLocation(), BlockStorage.retrieve((Block)targetBlock));
                        targetBlock.setType(Material.AIR);
                    } else {
                        ItemStack vanilla = new ItemStack(targetBlock.getType());
                        if (vanilla.isSimilar(VERSIONED_AMETHYST)) {
                            targetBlock.setType(Material.AIR);
                        } else {
                            location.dropItemNaturally(targetBlock.getLocation(), vanilla.clone());
                        }
                        targetBlock.setType(Material.AIR);
                    }
                    location.playSound(b.getLocation().add(0.5, 0.5, 0.5), Sound.UI_STONECUTTER_TAKE_RESULT, 1.0f, 1.0f);
                    b.getWorld().spawnParticle(Particle.SMOKE_LARGE, b.getLocation().add(1.0, 1.0, 1.0), 2, 0.1, 0.1, 0.1);
                } else {
                    ++progress;
                    this.takeCharge(b.getLocation());
                    location.playSound(b.getLocation().add(0.5, 0.5, 0.5), Sound.BLOCK_STONE_HIT, 1.0f, 1.0f);
                }
                breakerProgress.put(pos, progress);
            }
        }
    }

    private boolean isBed(Block targetBlock) {
        return targetBlock.getBlockData() instanceof Bed;
    }

    private boolean isDoor(Block targetBlock) {
        return targetBlock.getBlockData() instanceof Door;
    }

    public void onNewInstance(BlockMenu menu, Block b) {
        String breakMode = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"breakBlockNaturally");
        boolean currentMode = false;
        if (breakMode != null) {
            currentMode = Boolean.parseBoolean(breakMode);
        }
        mode.put(b.getLocation(), currentMode);
        menu.replaceExistingItem(0, (ItemStack)(currentMode ? breakBlockNaturally : dropBlockNaturally));
        menu.addMenuClickHandler(0, (p, slot, item, action) -> {
            this.toggleMode(menu, b);
            return false;
        });
    }

    public void toggleMode(BlockMenu blockMenu, Block b) {
        boolean change = mode.get(b.getLocation()) == false;
        BlockStorage.addBlockInfo((Block)b, (String)"breakBlockNaturally", (String)String.valueOf(change));
        mode.put(b.getLocation(), change);
        CustomItemStack itemStack = change ? breakBlockNaturally : dropBlockNaturally;
        blockMenu.replaceExistingItem(0, (ItemStack)itemStack);
    }

    public void onNewInstanceToggle(BlockMenu menu, Block b) {
        String isRunning = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"toggled_On");
        boolean onOrOff = false;
        if (isRunning != null) {
            onOrOff = Boolean.parseBoolean(isRunning);
        }
        toggleOnOff.put(b.getLocation(), onOrOff);
        menu.replaceExistingItem(8, (ItemStack)(onOrOff ? toggled_On : toggled_Off));
        menu.addMenuClickHandler(8, (p, slot, item, action) -> {
            this.toggleOnOrOff(menu, b);
            return false;
        });
    }

    public void toggleOnOrOff(BlockMenu blockMenu, Block b) {
        boolean toggleBlock = toggleOnOff.get(b.getLocation()) == false;
        BlockStorage.addBlockInfo((Block)b, (String)"toggled_On", (String)String.valueOf(toggleBlock));
        toggleOnOff.put(b.getLocation(), toggleBlock);
        CustomItemStack itemStack2 = toggleBlock ? toggled_On : toggled_Off;
        blockMenu.replaceExistingItem(8, (ItemStack)itemStack2);
    }

    public final ElectricBlockBreaker setRate(int rateTicks) {
        this.rate = Math.max(rateTicks, 1);
        return this;
    }

    @Nonnull
    public String getInventoryTitle() {
        return this.getItemName();
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public final ElectricBlockBreaker setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumedPerTick = energyConsumption;
        return this;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    public final ElectricBlockBreaker setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public boolean takeCharge(@Nonnull Location l) {
        Validate.notNull((Object)l, (String)"Can't attempt to take charge from a null location!");
        if (this.isChargeable()) {
            int charge = this.getCharge(l);
            if (charge < this.getEnergyConsumption()) {
                return false;
            }
            this.setCharge(l, charge - this.getEnergyConsumption());
            return true;
        }
        return true;
    }
}

