/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.staffs.abstracts.AbstractStaff;
import ne.fnfal113.fnamplifications.staffs.implementations.AirStriderTask;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class StaffOfAirStrider
extends AbstractStaff {
    private final Map<UUID, AirStriderTask> taskMap = new HashMap<UUID, AirStriderTask>();
    private final Map<UUID, Long> playerCooldowMap = new HashMap<UUID, Long>();

    public StaffOfAirStrider(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 10, Keys.createKey("airstriderstaff"));
    }

    @Override
    public void onClick(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.taskMap.get(player.getUniqueId()) != null) {
            player.sendMessage(Utils.colorTranslator("&6Air strider is not yet expired!"));
            return;
        }
        if (!this.hasPermissionToCast(item.getItemMeta().getDisplayName(), player, player.getLocation())) {
            return;
        }
        player.sendMessage(Utils.colorTranslator("&dYou can now walk on the air for 10 seconds"));
        this.playerCooldowMap.put(player.getUniqueId(), System.currentTimeMillis());
        this.taskMap.put(player.getUniqueId(), new AirStriderTask(player));
        this.taskMap.get(player.getUniqueId()).runTaskTimer((Plugin)FNAmplifications.getInstance(), 0L, 1L);
        ItemMeta meta = item.getItemMeta();
        this.getStaffTask().updateMeta(item, meta, player);
        Bukkit.getScheduler().runTaskTimer((Plugin)FNAmplifications.getInstance(), task -> {
            Long timer = Utils.cooldownHelper(this.playerCooldowMap.get(player.getUniqueId()));
            if (timer >= 7L) {
                player.sendMessage(Utils.colorTranslator("&dAir strider will expire in ") + (12L - timer) + " seconds!");
            }
            if (timer >= 12L || !player.isOnline()) {
                player.sendMessage(Utils.colorTranslator("&dAir Strider has expired!"));
                this.playerCooldowMap.remove(player.getUniqueId());
                this.taskMap.get(player.getUniqueId()).setDone(true);
                this.taskMap.remove(player.getUniqueId());
                task.cancel();
            }
        }, 0L, 20L);
    }
}

