/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines.abstracts;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Jukebox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractJukeBox
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    public CustomItemStack NOT_OPERATING = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&cNot Operating!", new String[]{"&eClick Play Button"});
    public CustomItemStack OPERATING = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, "&cOperating!", new String[0]);
    public CustomItemStack NO_POWER = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNo Power!", new String[]{"&ePower it up first!"});
    public CustomItemStack NOT_RUNNING = new CustomItemStack(Material.YELLOW_STAINED_GLASS_PANE, "&cNot Running", new String[]{"&eToggle it on first"});
    public CustomItemStack TOGGLED_ON = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, "&dToggle:", new String[]{"&eEnabled", "Click to change"});
    public CustomItemStack TOGGLED_OFF = new CustomItemStack(Material.WHITE_STAINED_GLASS_PANE, "&dToggle:", new String[]{"&eDisabled", "Click to change"});
    public CustomItemStack PLAY = new CustomItemStack(PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)"cecd041f628c005a690fc6b8237e7311bb7c3b3aac10539fefe396a4c7c783e7")), "&dStop", new String[0]);
    public CustomItemStack STOP = new CustomItemStack(PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)"fa8f6b131ef847d9160e516a6f44bfa932554d40c18a81796d766a5487b9f710")), "&dPlay", new String[0]);
    public CustomItemStack PREVIOUS = new CustomItemStack(PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)"32ff8aaa4b2ec30bc5541d41c8782199baa25ae6d854cda651f1599e654cfc79")), "&dPrevious disc", new String[0]);
    public CustomItemStack NEXT = new CustomItemStack(PlayerHead.getItemStack((PlayerSkin)PlayerSkin.fromHashCode((String)"aab95a8751aeaa3c671a8e90b83de76a0204f1be65752ac31be2f98feb64bf7f")), "&dNext disc", new String[0]);
    private int energyCapacity = -1;
    private int energyConsumedPerTick = -1;

    public AbstractJukeBox(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public void takeCharge(@Nonnull Location l) {
        if (this.isChargeable()) {
            int charge = this.getCharge(l);
            if (charge < this.getEnergyConsumption()) {
                return;
            }
            this.setCharge(l, charge - this.getEnergyConsumption());
        }
    }

    public final AbstractJukeBox setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumedPerTick = energyConsumption;
        return this;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    public final AbstractJukeBox setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public abstract void changeStatus(BlockMenu var1);

    public abstract void toggleOnOrOff(BlockMenu var1);

    public abstract void goToPreviousSlot(BlockMenu var1, @Nullable Player var2);

    public abstract void goToNextSlot(BlockMenu var1, @Nullable Player var2);

    public abstract void playOrStopJukebox(BlockMenu var1, Player var2);

    public abstract void playSlot(BlockMenu var1, Jukebox var2, int var3);

    public abstract void unselectAndStopPlayingSlot(BlockMenu var1, Jukebox var2);

    public abstract void validateSlotChange(BlockMenu var1, Jukebox var2, int var3);

    public abstract void changeSlot(BlockMenu var1, Jukebox var2, int var3);

    public abstract void unselectCurrentSlot(BlockMenu var1);

    public abstract void selectDisc(BlockMenu var1);

    public abstract void unselectDisc(BlockMenu var1);

    public abstract boolean slotContainsMusicDisc(BlockMenu var1, int var2);
}

