/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.items.FNAmpItems;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FnMagicAltar
extends MultiBlockMachine {
    public static final RecipeType RECIPE_TYPE = new RecipeType(new NamespacedKey((Plugin)FNAmplifications.getInstance(), "fn_magic_altar"), FNAmpItems.FN_MAGIC_ALTAR, new String[]{"", "&fThis is where you craft magical items!"});

    public FnMagicAltar() {
        super((ItemGroup)FNAmpItems.MULTIBLOCK, FNAmpItems.FN_MAGIC_ALTAR, new ItemStack[]{null, null, null, null, new ItemStack(Material.ACACIA_FENCE), null, new ItemStack(Material.ENCHANTING_TABLE), new ItemStack(Material.DISPENSER), new ItemStack(Material.SMITHING_TABLE)}, BlockFace.SELF);
    }

    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState((Block)dispBlock, (boolean)false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            List inputs = RecipeType.getRecipeInputList((MultiBlockMachine)this);
            for (int i = 0; i < inputs.size(); ++i) {
                if (!this.canCraft(inv, (ItemStack[])inputs.get(i))) continue;
                ItemStack output = RecipeType.getRecipeOutputList((MultiBlockMachine)this, (ItemStack[])((ItemStack[])inputs.get(i))).clone();
                if (SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)output, (boolean)true)) {
                    this.craft(dispBlock, p, b, inv, (ItemStack[])inputs.get(i), output);
                }
                return;
            }
            if (inv.isEmpty()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
            }
        }
    }

    private boolean canCraft(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true)) continue;
            return false;
        }
        return true;
    }

    protected void craft(Block dispenser, Player p, Block b, Inventory inv, ItemStack[] recipe, ItemStack output) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            this.craftItem(inv, recipe, b);
            outputInv.addItem(new ItemStack[]{output});
        } else {
            this.craftItem(inv, recipe, b);
            dispenser.getWorld().dropItem(b.getLocation(), output);
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
            p.sendMessage(Utils.colorTranslator("&dCrafted item has been dropped instead"));
        }
        if (output.getItemMeta().hasDisplayName()) {
            p.sendMessage(Utils.colorTranslator("&dSuccessfully crafted " + output.getItemMeta().getDisplayName() + "!"));
        } else {
            p.sendMessage(Utils.colorTranslator("&dSuccessfully crafted item!"));
        }
    }

    public void craftItem(Inventory inv, ItemStack[] recipe, Block b) {
        for (int j = 0; j < 9; ++j) {
            ItemStack item = inv.getContents()[j];
            if (item == null || item.getType() == Material.AIR || !SlimefunUtils.isItemSimilar((ItemStack)inv.getContents()[j], (ItemStack)recipe[j], (boolean)true)) continue;
            ItemUtils.consumeItem((ItemStack)item, (int)recipe[j].getAmount(), (boolean)true);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
            b.getWorld().spawnParticle(Particle.CLOUD, b.getLocation().add(0.5, 0.7, 0.5), 5, 0.1, 0.1, 0.1);
            b.getWorld().spawnParticle(Particle.FLASH, b.getLocation().add(0.3, 0.4, 0.45), 2, 0.1, 0.1, 0.1, 0.1);
            b.getWorld().playSound(b.getLocation(), Sound.ENTITY_ZOMBIE_INFECT, 1.0f, 1.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
                b.getWorld().playEffect(b.getLocation().add(0.5, 0.7, 0.5), Effect.MOBSPAWNER_FLAMES, 1);
                b.getWorld().spawnParticle(Particle.FLASH, b.getLocation().add(0.4, 0.45, 0.5), 2, 0.1, 0.1, 0.1, 0.1);
                b.getWorld().spawnParticle(Particle.CLOUD, b.getLocation().add(0.4, 0.45, 0.5), 2, 0.1, 0.1, 0.1, 0.1);
                b.getWorld().playSound(b.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
                Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
                    b.getWorld().playEffect(b.getLocation().add(0.35, 0.75, 0.35), Effect.MOBSPAWNER_FLAMES, 1);
                    b.getWorld().spawnParticle(Particle.CLOUD, b.getLocation().add(0.2, 0.3, 0.2), 2, 0.1, 0.1, 0.1, 0.1);
                    b.getWorld().playSound(b.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
                    Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
                        b.getWorld().playEffect(b.getLocation().add(0.5, 0.7, 0.5), Effect.SMOKE, 1);
                        b.getWorld().spawnParticle(Particle.CLOUD, b.getLocation().add(0.35, 0.4, 0.4), 2, 0.1, 0.1, 0.1, 0.1);
                        b.getWorld().spawnParticle(Particle.FLASH, b.getLocation().add(0.35, 0.4, 0.4), 2, 0.1, 0.1, 0.1, 0.1);
                        b.getWorld().playSound(b.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
                    }, 30L);
                }, 30L);
            }, 30L);
        }, 30L);
    }

    @Nonnull
    protected Inventory createVirtualInventory(@Nonnull Inventory inv) {
        Inventory fakeInv = Bukkit.createInventory(null, (int)9, (String)"Fake Inventory");
        for (int j = 0; j < inv.getContents().length; ++j) {
            ItemStack stack = inv.getContents()[j];
            if (stack != null) {
                stack = stack.clone();
                ItemUtils.consumeItem((ItemStack)stack, (boolean)true);
            }
            fakeInv.setItem(j, stack);
        }
        return fakeInv;
    }
}

