/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.dough.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.bakedlibs.dough.common.CommonPatterns;
import io.github.bakedlibs.dough.versions.PrefixedVersion;
import io.github.bakedlibs.dough.versions.Version;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import ne.fnfal113.fnamplifications.dough.updater.AbstractPluginUpdater;
import ne.fnfal113.fnamplifications.dough.updater.PluginUpdater;
import ne.fnfal113.fnamplifications.dough.updater.UpdateInfo;
import ne.fnfal113.fnamplifications.dough.updater.UpdaterTask;
import org.bukkit.plugin.Plugin;

public class GitHubBuildsUpdater
extends AbstractPluginUpdater<PrefixedVersion> {
    private static final String API_URL = "https://thebusybiscuit.github.io/builds/";
    private final String repository;
    private final String prefix;

    public GitHubBuildsUpdater(@Nonnull Plugin plugin, @Nonnull File file, @Nonnull String repo) {
        this(plugin, file, repo, "DEV - ");
    }

    public GitHubBuildsUpdater(@Nonnull Plugin plugin, @Nonnull File file, @Nonnull String repo, @Nonnull String prefix) {
        super(plugin, file, GitHubBuildsUpdater.extractBuild(prefix, plugin));
        this.repository = repo;
        this.prefix = prefix;
    }

    @Override
    public void start() {
        try {
            URL versionsURL = new URL(API_URL + this.repository + "/builds.json");
            this.scheduleAsyncUpdateTask(new UpdaterTask<PrefixedVersion>((PluginUpdater)this, versionsURL){

                @Override
                public UpdateInfo parse(String result) throws MalformedURLException {
                    JsonObject json = (JsonObject)new JsonParser().parse(result);
                    if (json == null) {
                        GitHubBuildsUpdater.this.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to github.io, is it down?");
                        return null;
                    }
                    int latestVersion = json.get("last_successful").getAsInt();
                    URL downloadURL = new URL(GitHubBuildsUpdater.API_URL + GitHubBuildsUpdater.this.repository + "/" + CommonPatterns.SLASH.split(GitHubBuildsUpdater.this.repository)[1] + "-" + latestVersion + ".jar");
                    return new UpdateInfo(downloadURL, (Version)new PrefixedVersion(GitHubBuildsUpdater.this.prefix, latestVersion));
                }
            });
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", e);
        }
    }
}

