/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.staffs.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class AirStriderTask
extends BukkitRunnable {
    private final Map<UUID, List<Block>> blockMap = new HashMap<UUID, List<Block>>();
    private final Map<UUID, Location> playerLocationMap = new HashMap<UUID, Location>();
    private final Player player;
    private boolean isDone = false;

    public AirStriderTask(Player player) {
        this.player = player;
    }

    public void run() {
        if (!this.player.isOnline()) {
            return;
        }
        if (this.blockMap.get(this.getPlayer().getUniqueId()) != null) {
            List<Block> block = this.blockMap.get(this.getPlayer().getUniqueId());
            if (block != null) {
                for (Block blocks : block) {
                    if (blocks == null) continue;
                    blocks.setType(Material.AIR);
                }
            }
            this.blockMap.remove(this.getPlayer().getUniqueId());
        }
        ArrayList<Block> blockList = new ArrayList<Block>();
        this.playerLocationMap.put(this.getPlayer().getUniqueId(), this.getPlayer().getLocation());
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                Block newBlock = this.getPlayer().getLocation().getBlock().getRelative(x, -1, z);
                if (newBlock.getType() != Material.AIR) continue;
                blockList.add(newBlock);
                newBlock.setType(Material.BARRIER);
                this.blockMap.put(this.getPlayer().getUniqueId(), blockList);
            }
        }
        if (this.isDone()) {
            List<Block> blocks = this.blockMap.get(this.getPlayer().getUniqueId());
            if (blocks != null) {
                for (Block block : blocks) {
                    block.setType(Material.AIR);
                }
            }
            this.cancel();
        }
    }

    public Map<UUID, List<Block>> getBlockMap() {
        return this.blockMap;
    }

    public Map<UUID, Location> getPlayerLocationMap() {
        return this.playerLocationMap;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }
}

