/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.tools.implementation;

import java.util.Objects;
import java.util.function.Consumer;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThrowableItemTask
extends BukkitRunnable {
    private final Player player;
    private final ItemStack itemStack;
    private final Vector vector;
    private final ArmorStand armorStand;
    private final Consumer<ThrowableItemTask> throwableItemTaskConsumer;

    public ThrowableItemTask(Player player, ItemStack itemStack, Vector vector, Consumer<ThrowableItemTask> throwableItemTaskConsumer) {
        this.player = player;
        this.itemStack = itemStack;
        this.vector = vector;
        this.armorStand = this.spawnArmorstand();
        this.throwableItemTaskConsumer = throwableItemTaskConsumer;
    }

    public ArmorStand spawnArmorstand() {
        return (ArmorStand)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation().add(0.0, 0.9, 0.0), ArmorStand.class, armorStand -> {
            armorStand.setArms(true);
            armorStand.setSmall(true);
            armorStand.setMarker(true);
            armorStand.setGravity(false);
            armorStand.setVisible(false);
            armorStand.setCustomNameVisible(false);
            armorStand.setPersistent(false);
            armorStand.setBasePlate(false);
            armorStand.setRightArmPose(Utils.setRightArmAngle(armorStand, 270, 0, 0));
            Objects.requireNonNull(armorStand.getEquipment()).setItemInMainHand(this.getItemStack().clone());
        });
    }

    public void run() {
        this.getThrowableItemTaskConsumer().accept(this);
    }

    public void dropItemTask(ArmorStand as, ItemStack itemStack) {
        itemStack.setAmount(1);
        Item droppedItem = as.getWorld().dropItemNaturally(as.getLocation(), itemStack.clone());
        droppedItem.setGlowing(true);
        as.remove();
        this.cancel();
    }

    public void removeItemTask(ArmorStand as) {
        as.remove();
        this.cancel();
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Vector getVector() {
        return this.vector;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Consumer<ThrowableItemTask> getThrowableItemTaskConsumer() {
        return this.throwableItemTaskConsumer;
    }
}

