/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class Gem {
    private final SlimefunItem slimefunGemItem;
    private final String SlimefunGemItemName;
    private final ItemStack itemStackToSocket;
    private final String SlimefunGemItemID;
    private final Player player;
    private final NamespacedKey SlimefunGemItemIDKey;
    private final NamespacedKey socketAmountKey;

    @ParametersAreNonnullByDefault
    public Gem(SlimefunItem slimefunGemItem, ItemStack itemStackToSocket, Player player) {
        this.slimefunGemItem = slimefunGemItem;
        this.itemStackToSocket = itemStackToSocket;
        this.player = player;
        this.SlimefunGemItemName = slimefunGemItem.getItemName();
        this.SlimefunGemItemID = slimefunGemItem.getId();
        this.SlimefunGemItemIDKey = Keys.createKey(slimefunGemItem.getId().toLowerCase());
        this.socketAmountKey = Keys.createKey(itemStackToSocket.getType().toString().toLowerCase() + "_socket_amount");
    }

    public void startSocket() {
        ItemMeta meta = this.getItemStackToSocket().getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int itemGemAmount = this.checkGemAmount(pdc, this.getItemStackToSocket());
        if (itemGemAmount < 5) {
            if (!this.isSameGem(this.getItemStackToSocket())) {
                this.getPlayer().setItemOnCursor(new ItemStack(Material.AIR));
                this.socketGemToItemStack(meta, pdc, itemGemAmount);
            } else {
                this.getPlayer().sendMessage(Utils.colorTranslator("&6Your item has " + this.getSlimefunGemItemName() + " &6socketed already!"));
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BAT_TAKEOFF, 1.0f, 1.0f);
            }
            return;
        }
        this.getPlayer().sendMessage(Utils.colorTranslator("&eOnly 5 gems per item are allowed!"));
        this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BLAZE_HURT, 1.0f, 1.0f);
    }

    public void socketGemToItemStack(ItemMeta meta, PersistentDataContainer pdc, int itemGemAmount) {
        List<String> lore;
        String gemSlimefunItemname = this.getSlimefunGemItemName();
        List<String> list = lore = meta.hasLore() ? (lore = meta.getLore()) : new ArrayList();
        if (itemGemAmount == 0) {
            lore.add("");
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            lore.add(ChatColor.RED + "\u25ec " + gemSlimefunItemname);
            lore.add(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4&c\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"));
            meta.setLore(lore);
        } else {
            for (int i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).startsWith(Utils.colorTranslator("&6\u25e4\u25e4\u25e4\u25e4\u25e4\u25e4| &d&lGems &c|\u25e5\u25e5\u25e5\u25e5\u25e5\u25e5"))) continue;
                lore.add(i + 1, ChatColor.RED + "\u25ec " + gemSlimefunItemname);
            }
            meta.setLore(lore);
        }
        pdc.set(this.getSlimefunGemItemIDKey(), PersistentDataType.STRING, (Object)this.getSlimefunGemItemID());
        pdc.set(this.getSocketAmountKey(), PersistentDataType.INTEGER, (Object)(itemGemAmount + 1));
        this.getItemStackToSocket().setItemMeta(meta);
        this.getPlayer().sendMessage(Utils.colorTranslator("&eSuccessfully bound " + gemSlimefunItemname + " &eto " + this.getItemStackToSocket().getType().name().replace("_", " ").toLowerCase(Locale.ROOT)));
        this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
    }

    public int checkGemAmount(PersistentDataContainer pdc, ItemStack itemStack) {
        return (Integer)pdc.getOrDefault(Keys.createKey(itemStack.getType().toString().toLowerCase() + "_socket_amount"), PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isSameGem(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.isEmpty()) {
            return false;
        }
        return container.has(this.getSlimefunGemItemIDKey(), PersistentDataType.STRING);
    }

    public SlimefunItem getSlimefunGemItem() {
        return this.slimefunGemItem;
    }

    public String getSlimefunGemItemName() {
        return this.SlimefunGemItemName;
    }

    public ItemStack getItemStackToSocket() {
        return this.itemStackToSocket;
    }

    public String getSlimefunGemItemID() {
        return this.SlimefunGemItemID;
    }

    public Player getPlayer() {
        return this.player;
    }

    public NamespacedKey getSlimefunGemItemIDKey() {
        return this.SlimefunGemItemIDKey;
    }

    public NamespacedKey getSocketAmountKey() {
        return this.socketAmountKey;
    }
}

